FLOW_INPUTS = ["transactions_dataset", "rf_segments_identication"]
FLOW_INPUTS_EDITABLES = ["rf_segments_identication"]
FLOW_INPUTS_FOR_DYNAMIC_DATA_INGESTION = ["transactions_dataset"]

COLUMN_FOR_RECENCY_COMPUTATION = "days_since_last_transaction" # Could be "days_between_first_and_last_transaction" depending on the way we want to define the recency

COLUMNS_FOR_ARRAYS_AVERAGE_COMPUTATION = {"basket_total_amount_concat":"average_basket",
                                          "purchased_items_concat": "average_purchased_items"}

COLUMNS_FOR_ARRAYS_SUM_COMPUTATION = {"basket_total_amount_concat":"total_basket",
                                      "purchased_items_concat": "total_purchased_items"}

BUILD_RFM_SCENARIOS = ["PREPROCESS_TRANSACTIONS", "PREPROCESS_DATA_FOR_RFM_COMPUTATION", "COMPUTE_RFM_SEGMENTS"]
BUILD_RFM_PROPAGATION_SCENARIOS = ["PREPROCESS_DATA_FOR_RFM_PROPAGATION", "PROPAGATE_RFM_SEGMENTS", "EXTRACT_INFORMATION_FROM_RFM_PROPAGATION"]
BUILD_ALL_FLOW_SCENARIOS = BUILD_RFM_SCENARIOS+BUILD_RFM_PROPAGATION_SCENARIOS

FLOW_REFRESH_SCENARIO_ID = "REFRESH_FLOW_OVER_TIME"

TIME_TRIGGER_FREQUENCY_TO_UNITS = {"Monthly": "months", "Weekly": "weeks", "Daily": "days", "Hourly": "hours"}

LOWER_OUTLIERS_QUANTILE_TRESHOLD = 0
HIGHER_OUTLIERS_QUANTILE_TRESHOLD = 0.99


FLOW_ZONES_RFM_PROPAGATION_SHARED_DATASETS = {
    "rfm_propagation_preprocessing": ["transactions_prepared"],
    "rfm_propagation": ["customer_rfm_segments", "propagation_customer_rfm_inputs",
                        "rf_segments_identication_synced"],
    "rfm_propagation_last_dates": ["all_customer_rfm_segments"],
    "rfm_propagation_transitions": ["all_customer_rfm_segments"],
    "rfm_propagation_scores": ["all_customer_rfm_segments"],
    "webapp_zone": ["last_customer_rfm_segments_recent_dates"]
}

FLOW_ZONES_RFM_PROPAGATION_DATASETS = {
    "rfm_propagation_preprocessing": ["transactions_for_rfm_propagation", "propagation_months",
                                      "propagation_customer_baskets", "propagation_distinct_customers",
                                      "propagation_customer_monthly_baskets", "propagation_possible_customer_montly_interactions",
                                      "propagation_customer_montly_interactions", "propagation_customer_purchasing_actions",
                                      "propagation_customer_rfm_inputs"
                                     ],
    "rfm_propagation": ["propagation_customer_rfm_segments", "propagation_only_customer_rfm_segments",
                       "all_customer_rfm_segments"],
    "rfm_propagation_last_dates": ["last_customer_rfm_segments", "last_customer_rfm_segments_recent_dates", "inactive_customers"],
    "rfm_propagation_transitions": ["all_customer_rfm_transitions", "all_customer_rfm_transitions_prepared",
                                    "segment_label_transitions", "recency_transitions", "frequency_transitions",
                                    "monetary_value_transitions", "density_transitions"],
    "rfm_propagation_scores": ["rfm_score_over_time"]
}

FLOW_ZONES_RFM_PROPAGATION = ["rfm_propagation_preprocessing", "rfm_propagation", "rfm_propagation_transitions",
                              "rfm_propagation_last_dates", "rfm_propagation_scores"]
FLOW_ZONES_RFM_PROPAGATION_COLORS = {"rfm_propagation_preprocessing": "#8C2DA7", "rfm_propagation": "#F9BE40",
                                     "rfm_propagation_transitions": "#F9BE40", "rfm_propagation_last_dates": "#F9BE40",
                                     "rfm_propagation_scores": "#F9BE40"}