# フローゾーンの説明

[RFMの伝播 前処理](flow_zone:18GatwZ) は、**顧客ID** x **年/月**の単位で取引データを集約し、顧客の購入月ごとに、RFMスコア計算を適用する特徴量を取得するために使用します。
[RFMの前処理](article:28) とは逆に、[日付フィルター方式](article:43) で定義した期間より広い期間で顧客のRFMを評価します。

![rfm_propagation_preprocessing.png](met49RMcUxBo)


- レシピ [compute_transactions_for_rfm_propagation](recipe:compute_transactions_for_rfm_propagation) は、[propagation_start_date - propagation_end_date] の範囲に含まれる取引データにフィルターをかけます。
- 「propagation_start_date」の初期値は、アプリケーションで定義された日付です([詳細は「RFMの伝播」を参照](article:40))．
      - この日付は、プロジェクトの自動化を有効にすると、フローが構築されるたびに更新されます（[詳細は「自動化」のセクションを参照](article:42))。
- propagation_end_date "は、フローをビルドした時点の日付です。

- レシピ[compute_propagation_customer_baskets](recipe:compute_propagation_customer_baskets) は、 **顧客ID** x **取引ID** の単位でデータを集約し、以下の情報を持つことができるようにします。
  - 顧客取引バスケットの合計金額
  - 顧客取引で購入された商品の総数

- レシピ [compute_propagation_customer_monthly_baskets](recipe:compute_propagation_customer_monthly_baskets) は **顧客ID** x **年/月**の単位でデータを集約し、以下の情報を得ることができるようにします。
  - 毎月の顧客の購入日の「最初」と「最後」
  - 各顧客が行ったトランザクション数
  - 顧客のバスケット金額の合計
  - 顧客が購入した商品数の合計

- レシピ [compute_propagation_months](recipe:compute_propagation_months) はRFM伝播の期間に含まれるすべての**年/月**を計算します。

- レシピ [compute_propagation_distinct_customers](recipe:compute_propagation_distinct_customers) は**顧客ID**でデータを集約し、RFM伝播期間中に購入した全ての顧客のリストを取得します。

- レシピ [compute_propagation_possible_customer_montly_interactions](recipe:compute_propagation_possible_customer_montly_interactions) はデータセット [propagation_months](dataset:propagation_months) と [propagation_distinct_customers](dataset:propagation_distinct_customers) を結合し、可能性のあるすべての顧客の月別インタラクションが入ったデータセットができるようにします。これは、RFM伝播期間に存在するすべての月について、**顧客ID** x **年/月**を単位としたデータセットになります。

- データセット [propagation_possible_customer_montly_interactions](dataset:propagation_possible_customer_montly_interactions) ができたので、各月の [focus_month - (T + 1) ; focus_month -1] の範囲で顧客行動を調べます。**T** は基準期間でRFMを計算したときに考慮した月数 に相当します。レシピ [compute_propagation_customer_purchasing_actions](recipe:compute_propagation_customer_purchasing_actions) では以下の集計を行なっています。
  - 「最初の」購入日と「最後の」購入日
     - 各「基準月」と「最終購入日」の差から、特徴量「days_since_last_transaction」を算出し、[RFMセグメンテーション](article:13) で学んだ **R**スコアを適用します。
      - 「最後の」購入日と「最初の」購入日の差は、「days_between_first_and_last_transaction」となり、さらなる分析やデータエンリッチメントに使用することが可能です。
  - 顧客の月間取引件数：この情報は**F**スコアを適用するために使用されます。
  - 顧客のバスケット金額の合計：この情報は[RFMセグメンテーション](article:13) で学んだ **M**スコアを適用するために使用されます。
  - 顧客が購入した商品数の合計：同様に、この情報は[RFMセグメンテーション](article:13) で学習した**D**スコアを適用するために使用されます。

- 最後に、レシピ [compute_propagation_customer_rfm_inputs](recipe:compute_propagation_customer_rfm_inputs) で以下を行います: 
  - 前述した日付の差分を計算する
  - [RFMの伝播](article:32)を開始する前に、python配列として扱うため、「バスケット金額」と「購入個数」の合計情報を変換する