このセクションでは、当ソリューションを使用するために必要な要件について説明します。

# インスタンス要件

このソリューションは、**Dataiku DSS V9 以上**を使用したインスタンスにのみ対応しています。

## コード環境（Code Environment）
プロジェクトの python レシピは code env として **solution_rfm-segmentation** を利用します。

この code env は以下のパッケージを必要とします。
>dateparser==1.0.0
regex==2022.3.2
scikit-learn>=0.20,<0.21
Flask==2.0.2
plotly==5.5.0
nbformat==4.2.0
matplotlib==3.3.4

## 必須プラグイン

DSSインスタンスには以下プラグインのインストールが必要です。
- [dataiku's sankey charts plugin](https://www.dataiku.com/product/plugins/flow-charts/).


### DSSプラグインのインストールについて
[DSSプラグインのインストール方法](https://doc.dataiku.com/dss/latest/plugins/installing.html)


# データソース要件

トランザクションの分析がプロジェクトの中核であるため、トランザクション履歴を持つことは **必須** です。

**データフォーマット要件**: 1行が保持する情報：
- ***商品*** (商品ID)
- ***バスケットによる購入*** (トランザクションID)
- ***数量*** (商品数量)
- ***単価*** (商品価格)
- ***購入日*** (日付カラム)
- ***顧客*** (顧客ID)


# データストレージ要件

Dataikuの***RFM セグメンテーション*** アプリケーションは、SQLストレージを利用して動作するように設計されています。
すべてのアプリケーション要素からそのままメリットを得るためには、次の接続を使用します。
- PostgreSQL
- Snowflake

他のデータストレージと接続したい場合には、必要に応じて、展開とカスタマイズのためのサービスを利用することもできます。


