# プロジェクトの目的
このプロジェクトは、**購買行動によって顧客をセグメント化し、よりカスタマイズされたインタラクションができるようにするものです。**
これにより、ベスト/ワーストの顧客を簡単に識別することができます。
  - 最も最近購入/最近でない顧客 (**R**ecent)
  - 最も購入頻度が高い/低い顧客 (**F**requently)
  - 最も金額的価値の高い/低い顧客 (**M**onetary value)
  
これは、***RFMセグメンテーション***として知られています。 ([このセグメンテーション手法について詳しく知る](article:13)).


# プロジェクトの価値
データドリブンなアプローチで顧客購買行動のセグメント化を支援することで、このプロジェクトは以下のようなニーズに応えます。

## 顧客の購買行動を俯瞰的に把握したい
![webapp_segments_by_monetary_value.png](iv8BvdpWKuM7)

上記のグラフは :arrow_up: [project's webapp](article:8) で利用可能な分析結果の一つです。 
顧客セグメントの分布を金額別に分析することができます。この情報を活用することで、以下のことが可能になります。
- 顧客の購買特性を知ることができます。
- 非活動顧客を特定します。
- 顧客のリテンションを最適化します
- マーケティング戦略を顧客のセグメント分布に合わせます。
- ロイヤルカスタマー、リスクカスタマー、中間的なカスタマーを識別することで、顧客とのコミュニケーション方法を改善します。

[RFMセグメンテーションダッシュボード](dashboard:V3bvyr2) では、各セグメントに直接アクセスして、その内容やサイズに関する情報を得ることができます。


## 顧客がどのように変化するのかを時系列で確認したい

![segment_labels_transitions.png](CsTwEtgEyI0h)

上記の図 :arrow_up: は、あるRFM評価から別の評価への、セグメントに属する顧客間の観察された遷移を分析したものです。これは、顧客がどのように変化する傾向があるかを理解するのに役立ちます。この情報は、コミュニケーション戦略を調整し、対話したいセグメントの優先順位を決定するのに役立ちます。
[RFMの遷移について詳しく知る](article:52)


また、このプロジェクトでは、下図のように、RFMスコアが時間とともにどのように変化したかを追跡することができます :arrow_down:
![rfm_scores_over_time.png](FtrwtuN3kU4a)
[RFMスコアの時間による変化について詳しく知る](article:53)
