# 仕組み
***RFMセグメンテーション***で分位数法を利用する場合、特徴量の固まりを計算するために十分位を使用します。
例えば、**M**軸を計算するために、バスケット全体を5つの固まりに分けたい場合、2、4、6、8番目の十分位を調べます。
- 十分位2未満の数値は、**M**の値を1とします。
- 十分位2以上4未満の数値は、**M**の値を2とします。
- 十分位4以上6未満の数値は、**M**の値を3とします。
- 十分位6以上8未満の数値は、**M**の値を4とします。
- 十分位8以上の数値は、**M**の値を5とします。


# 具体例

2500人の顧客からなるデータセットにおいて、以下のような顧客の「バスケット金額合計」分布があるとします。:arrow_down:

![total_basket_distribution.png](09velPXoCMT5)

十分位を計算すると以下の結果となります:
- 十分位2  = 2895.67 --> この分位数未満の値は**M**1とします。
- 十分位4  = 3567.46  --> 2895.67と3567.46の間の値は**M**2とします。
- 十分位6  = 4500.87  --> 3567.46と4500.87の間の値は**M**3とします。
- 十分位8  = 5050.62  --> 4500.87と5050.62の間の値は**M**4とします。
- 最後に、5050.62以上の値は**M**5とします。


したがって、分位法を適用すると、**M**スコアは以下のような分布となります。:arrow_down:

![monetary_value_scores_distribution_quantile_method.png](Y2sO3YPT5Enw)


5つのセグメントには、それぞれ500人の顧客がいます :arrow_down:
![monetary_value_scores_counts_quantile_method.png](tHeXs30kMsVP)
- **注**: データの内容によっては、分位数が他の分位数を吸収してしまう（重なる）可能性があります。これは、列の中に重複する値が多数存在する場合、発生する可能性があります。



