# 概念の定義
[Wikipediaの定義](https://en.wikipedia.org/wiki/Cluster_analysis) 
> **クラスタリング**とは、あるオブジェクトの集合を、同じグループ（クラスタと呼ぶ）に属するオブジェクトが他のグループ（クラスタ）に属するオブジェクトよりも、（ある観点で）類似性が高いようにグループ化する作業である。

>探索的データ解析における主要な作業、また統計的データ解析の一般的な手法として、パターン認識、画像解析、情報検索、バイオインフォマティクス、データ圧縮、コンピュータグラフィックス、機械学習など多くの分野で利用されている。


## 直感的な理解

顧客の購買総額が以下のように分布していると仮定します。:arrow_down:

![total_basket_distribution_2_groups.png](xons0CjfSOxf)

:arrow_up:ここでは、2つの主要な顧客グループがあり、一方（左のベルカーブ）は他方（右のベルカーブ）よりも支出が少ないことが見て取れます。

クラスタリングモデルの直感的な理解としては、計算によってデータを均質なグループに分けることができるということです。


## 例

データに2クラスタのk平均法 ([k平均法とは？](article:21)) を適用すると、次のような結果になります。 :arrow_down:

![total_basket_distribution_2_groups_kmeans.png](Gt3NAIz6gj6E)

:arrow_up: k平均法により、2つのグループに分割されたことがわかります。


