# フローゾーンの説明

[RFMの前処理](flow_zone:mVAdv0W)は、取引データを顧客単位で集約し、RFM情報の計算に使われる特徴量を得ることに特化しています。これは、[date filtering strategy (日付フィルター方式)](Article:43)で定義した期間の全取引に焦点を合わせています。

![rfm_preprocessing.png](WelxmRLhrHBI)

- レシピ [compute_transactions_rfm_filtered_dates](recipe:compute_transactions_rfm_filtered_dates) は、[date filtering strategy](article:43) に従って取引データをフィルタリングします。

- レシピ[compute_customer_baskets](recipe:compute_customer_baskets) は、**customer_id** x **transaction_id** の単位でデータを集約し、以下の情報を持つことができるようにします。
  - 顧客取引バスケットの合計金額
  - 顧客取引で購入された商品の総数
  
- レシピ[compute_customer_purchasing_actions](recipe:compute_customer_purchasing_actions) は **customer_id** の単位でデータを集約し、以下の情報を持つことができるようにします。
  - 「最初の」購入日と「最後の」購入日
     - その後、トランザクションの基準日([トランザクションの前処理](article:27) 参照)と「最後の購入日」の差から、「days_since_last_transaction」という特徴量を計算します。これにより **R**スコアを学習し適用することができます。
      - 最後の」購入日と「最初の」購入日の差から、「days_between_first_and_last_transaction」を算出し、さらなる分析やデータエンリッチメントに使用することができます。
  - 各顧客が行った取引回数：この特徴量は、**F**スコアを学習し適用するために使用されます。
  - 顧客バスケットの平均と合計： *monetary value policy*（[RFM](article:39)参照）に応じて、 **M**スコアを学習し適用するためにどちらか一方が使用されます。
  - 顧客が購入したアイテムの数の平均と合計：同様に、**D**スコアを学習し適用するために、*monetary value policy*に応じてどちらか一方が使用されます。（[「Dencity: 密度」とは](article:13)参照）

- レシピ [compute_customer_rfm_inputs](recipe:compute_customer_rfm_inputs) は最後に、前述の日付間の差分を計算します。