# RFMセグメントエクスプローラー


[このWebアプリ](web_app:EY4mlPQ) を使用すると、**RFM** セグメント内の顧客の分布を調べることができます。

![webapp_homepage.png](NxHZ8PZS1DSU) 

___

# イメージの説明
![sample_project_treemap.png](OY7Hy5OThCc0)
上の :arrow_up: ビューは、**各セグメントに存在する顧客数**を表すもので、私たちはこれを **ツリーマップ** と呼んでいます。これは、長方形でネスト した分枝間の**データ階層**を表しています。**長方形の幅が広いほど、他の長方形に対してより重要であることを意味します**。
例えば、上記の場合、
- 外側の線は、チャートを表示する際に対象となる顧客の総数を表しています。**9214人の顧客**
- この最初の線（ブランチ）は、10のサブブランチに分かれており、それぞれが顧客セグメントの1つを表しています。
  - 最大のサブブランチは、「休眠中」セグメントを含んでいます。**5624人の顧客**
  - 2番目のサブブランチは、「ロイヤルカスタマー」セグメントを含んでいます。**976人の顧客**
  - そして、残りのセグメントも同様に続きます。


# Webアプリの操作
## ツリーマップ解析方法

「ツリーマップ解析方法」では、3種類の解析方法を選択することができます。
- **データ全体のセグメント分析**。このツリーマップは、データセットに出現する **[RFセグメント](article:23) を、金額とは無関係に表示します**。
- **金額的な相対的重要度によるセグメント分析**。このツリーマップは、データセットに出現する [RFセグメント](article:23) を**それぞれの金額的価値に応じて表示します。**したがって、最初のブロックは、特定の金額的価値を持つ顧客の量を表し、それらの相対的な面積によって、どのセグメントが最も代表的なセグメンテーションであるかを見ることができます。
- **金額的価値で分割したセグメント分析**: このツリーマップは、データセットに出現する**[RFセグメント](article:23)を、選択した特定の金額的価値に対して表示します。**

下のアニメーションは、解析方法を変更する様子を表したものです。 :arrow_down: 

![treemap.gif](idMRfXqDu9qN)


*金額的価値の相対的重要度を表すツリーマップと、金額的価値で分割したツリーマップの違いは何でしょうか。*
**前者**ではどの金額的価値が最も多く含まれているかは簡単にわかりますが、それぞれの金額的価値のRecency x Frequencyを比較することは困難です。

**後者**は金額的価値のセグメントそれぞれに存在する「Recency x Frequency」セグメントを簡単に比較できますが、金額的価値セグメントの相対的重要性について洞察を得ることはできません。


## RFMデータソース
このオプション :arrow_down: は [RFM propagation (RFM の伝播) ](article:40) を有効にした場合のみ利用可能です。
![webapp_rfm_datasource.png](Hul9HsLwcazf)

この設定では、Webアプリで分析する顧客を選択できます。
- **参照期間の顧客** (デフォルト設定): [customer_rfm_segments](dataset:customer_rfm_segments)を利用します。このデータセットは参照期間の設定に基づいて、顧客のRFM情報を保持します。
- **最近日付の顧客**：[last_customer_rfm_segments_recent_dates](dataset:last_customer_rfm_segments_recent_dates)を利用します。このデータセットは最も最近の顧客RFM情報を保持します。
- **非活動顧客**：[inactive_customers](dataset:inactive_customers)を利用します。このデータセットは最も最近の非活動顧客のRFM情報を保持します。



