
CDM_SCHEMA = {
    'person':[
        ('person_id', 'int', True),
        ('gender_concept_id', 'int', True),
        ('year_of_birth', 'int', True),
        ('month_of_birth', 'int', False),
        ('day_of_birth', 'int', False),
        ('birth_datetime', 'datetimenotz', True),
        ('race_concept_id', 'int', True),
        ('ethnicity_concept_id', 'int', True),
        ('location_id', 'int', False),
        ('provider_id', 'int', False),
        ('care_site_id', 'int', False),
        ('person_source_value', 'string', False),
        ('gender_source_value', 'string', False),
        ('gender_source_concept_id', 'int', False),
        ('race_source_value', 'string', False),
        ('race_source_concept_id', 'int', False),
        ('ethnicity_source_value', 'string', False),
        ('ethnicity_source_concept_id', 'int', False)],
    
    "observation_period":[
        ('observation_period_id', 'int', True),
        ('person_id', 'int', True),
        ('observation_period_start_date', 'dateonly', True),
        ('observation_period_end_date', 'dateonly', True),
        ('period_type_concept_id', 'int', True)],
    
    "visit_occurrence":[
        ('visit_occurrence_id', 'int', True),
        ('person_id', 'int', True),
        ('visit_concept_id', 'int', True),
        ('visit_start_date', 'dateonly', True),
        ('visit_start_datetime', 'datetimenotz', False),
        ('visit_end_date', 'dateonly', True),
        ('visit_end_datetime', 'datetimenotz', False),
        ('visit_type_concept_id', 'int', True),
        ('provider_id', 'int', False),
        ('care_site_id', 'int', False),
        ('visit_source_value', 'string', False),
        ('visit_source_concept_id', 'int', False),
        ('admitting_source_concept_id', 'int', False),
        ('admitting_source_value', 'string', False),
        ('discharge_to_concept_id', 'int', False),
        ('discharge_to_source_value', 'string', False),
        ('preceding_visit_occurrence_id', 'int', False)],

    "visit_detail":[
        ('visit_detail_id', 'int', True),
        ('person_id', 'int', True),
        ('visit_detail_concept_id', 'int', True),
        ('visit_detail_start_date', 'dateonly', True),
        ('visit_detail_start_datetime', 'datetimenotz', False),
        ('visit_detail_end_date', 'dateonly', True),
        ('visit_detail_end_datetime', 'datetimenotz', False),
        ('visit_detail_type_concept_id', 'int', True),
        ('provider_id', 'int', False),
        ('care_site_id', 'int', False),
        ('visit_detail_source_value', 'string', False),
        ('visit_detail_source_concept_id', 'int', False),
        ('admitting_source_concept_id', 'int', False),
        ('admitting_source_value', 'string', False),
        ('discharge_to_concept_id', 'int', False),
        ('discharge_to_source_value', 'string', False),
        ('preceding_visit_detail_id', 'int', False),
        ('visit_detail_parent_id', 'int', False),
        ('visit_occurrence_id', 'int', True)],
    
    "condition_occurrence":[
        ('condition_occurrence_id', 'int', True),
        ('person_id', 'int', True),
        ('condition_concept_id', 'int', True),
        ('condition_start_date', 'dateonly', True),
        ('condition_start_datetime', 'datetimenotz', False),
        ('condition_end_date', 'dateonly', True),
        ('condition_end_datetime', 'datetimenotz', False),
        ('condition_type_concept_id', 'int', True),
        ('condition_status_concept_id', 'int', False),
        ('stop_reason', 'string', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('condition_source_value', 'string', False),
        ('condition_source_concept_id', 'int', False),
        ('condition_status_source_value', 'string', False)],
    
    "drug_exposure":[
        ('drug_exposure_id', 'int', True),
        ('person_id', 'int', True),
        ('drug_concept_id', 'int', True),
        ('drug_exposure_start_date', 'dateonly', True),
        ('drug_exposure_start_datetime', 'datetimenotz', False),
        ('drug_exposure_end_date', 'dateonly', True),
        ('drug_exposure_end_datetime', 'datetimenotz', False),
        ('verbatim_end_date', 'dateonly', False),
        ('drug_type_concept_id', 'int', True),
        ('stop_reason', 'string', False),
        ('refills', 'int', False),
        ('quantity', 'float', False),
        ('days_supply', 'int', False),
        ('sig', 'string', False),
        ('route_concept_id', 'int', False),
        ('lot_number', 'string', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('drug_source_value', 'string', False),
        ('drug_source_concept_id', 'int', False),
        ('route_source_value', 'string', False),
        ('dose_unit_source_value', 'string', False)],
    
    "procedure_occurrence": [
        ('procedure_occurrence_id', 'int', True),
        ('person_id', 'int', True),
        ('procedure_concept_id', 'int', True),
        ('procedure_date', 'dateonly', True),
        ('procedure_datetime', 'datetimenotz', False),
        ('procedure_type_concept_id', 'int', True),
        ('modifier_concept_id', 'int', False),
        ('quantity', 'int', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('procedure_source_value', 'string', False),
        ('procedure_source_concept_id', 'int', False),
        ('modifier_source_value', 'string', False)],
    
    "device_exposure":[
        ('device_exposure_id', 'int', True),
        ('person_id', 'int', True),
        ('device_concept_id', 'int', True),
        ('device_exposure_start_date', 'dateonly', True),
        ('device_exposure_start_datetime', 'datetimenotz', False),
        ('device_exposure_end_date', 'dateonly', False),
        ('device_exposure_end_datetime', 'datetimenotz', False),
        ('device_type_concept_id', 'int', True),
        ('unique_device_id', 'string', False),
        ('quantity', 'int', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('device_source_value', 'string', False),
        ('device_source_concept_id', 'int', False)],

    "measurement": [
        ('measurement_id', 'int', True),
        ('person_id', 'int', True),
        ('measurement_concept_id', 'int', True),
        ('measurement_date', 'dateonly', True),
        ('measurement_datetime', 'datetimenotz', False),
        ('measurement_time', 'string', False),
        ('measurement_type_concept_id', 'int', True),
        ('operator_concept_id', 'int', False),
        ('value_as_number', 'float', False),
        ('value_as_concept_id', 'int', False),
        ('unit_concept_id', 'int', False),
        ('range_low', 'float', False),
        ('range_high', 'float', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('measurement_source_value', 'string', False),
        ('measurement_source_concept_id', 'int', False),
        ('unit_source_value', 'string', False),
        ('value_source_value', 'string', False)],
    
    "observation": [
        ('observation_id', 'int', True),
        ('person_id', 'int', True),
        ('observation_concept_id', 'int', True),
        ('observation_date', 'dateonly', True),
        ('observation_datetime', 'datetimenotz', False),
        ('observation_type_concept_id', 'int', True),
        ('value_as_number', 'float', False),
        ('value_as_string', 'string', False),
        ('value_as_concept_id', 'int', False),
        ('qualifier_concept_id', 'int', False),
        ('unit_concept_id', 'int', False),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('observation_source_value', 'string', False),
        ('observation_source_concept_id', 'int', False),
        ('unit_source_value', 'string', False),
        ('qualifier_source_value', 'string', False)],

    "death": [
        ('person_id', 'int', True),
        ('death_date', 'dateonly', True),
        ('death_datetime', 'datetimenotz', False),
        ('death_type_concept_id', 'int', False),
        ('cause_concept_id', 'int', False),
        ('cause_source_value', 'string', False),
        ('cause_source_concept_id', 'int', False)],
    
    "note": [
        ('note_id', 'int', True),
        ('person_id', 'int', True),
        ('note_date', 'dateonly', True),
        ('note_datetime', 'datetimenotz', False),
        ('note_type_concept_id', 'int', True),
        ('note_class_concept_id', 'int', True),
        ('note_title', 'string', False),
        ('note_text', 'string', True),
        ('encoding_concept_id', 'int', True),
        ('language_concept_id', 'int', True),
        ('provider_id', 'int', False),
        ('visit_occurrence_id', 'int', False),
        ('visit_detail_id', 'int', False),
        ('note_source_value', 'string', False)],

    "note_nlp": [
        ('note_nlp_id', 'int', True),
        ('note_id', 'int', True),
        ('section_concept_id', 'int', False),
        ('snippet', 'string', False),
        ('offset', 'string', False),
        ('lexical_variant', 'string', True),
        ('note_nlp_concept_id', 'int', False),
        ('note_nlp_source_concept_id', 'int', False),
        ('nlp_system', 'string', False),
        ('nlp_date', 'dateonly', True),
        ('nlp_datetime', 'datetimenotz', False),
        ('term_exists', 'string', False),
        ('term_temporal', 'string', False),
        ('term_modifiers', 'string', False)],

    "specimen": [
        ('specimen_id', 'int', True),
        ('person_id', 'int', True),
        ('specimen_concept_id', 'int', True),
        ('specimen_type_concept_id', 'int', True),
        ('specimen_date', 'dateonly', True),
        ('specimen_datetime', 'datetimenotz', False),
        ('quantity', 'float', False),
        ('unit_concept_id', 'int', False),
        ('anatomic_site_concept_id', 'int', False),
        ('disease_status_concept_id', 'int', False),
        ('specimen_source_id', 'string', False),
        ('specimen_source_value', 'string', False),
        ('unit_source_value', 'string', False),
        ('anatomic_site_source_value', 'string', False),
        ('disease_status_source_value', 'string', False)],
    
    "fact_relationship": [
        ('domain_concept_id_1', 'int', True),
        ('fact_id_1', 'int', True),
        ('domain_concept_id_2', 'int', True),
        ('fact_id_2', 'int', True),
        ('relationship_concept_id', 'int', True)],

    "location": [
        ('location_id', 'int', True),
        ('address_1', 'string', False),
        ('address_2', 'string', False),
        ('city', 'string', False),
        ('state', 'string', True),
        ('zip', 'string', False),
        ('county', 'string', True),
        ('location_source_value', 'string', False)],

    "care_site": [
        ('care_site_id', 'int', True),
        ('care_site_name', 'string', False),
        ('place_of_service_concept_id', 'int', False),
        ('location_id', 'int', False),
        ('care_site_source_value', 'string', False),
        ('place_of_service_source_value', 'string', False)],

    "provider": [
        ('provider_id', 'int', True),
        ('provider_name', 'string', False),
        ('npi', 'string', False),
        ('dea', 'string', False),
        ('specialty_concept_id', 'int', False),
        ('care_site_id', 'int', False),
        ('year_of_birth', 'int', False),
        ('gender_concept_id', 'int', False),
        ('provider_source_value', 'string', False),
        ('specialty_source_value', 'string', False),
        ('specialty_source_concept_id', 'int', False),
        ('gender_source_value', 'string', False),
        ('gender_source_concept_id', 'int', False)],
    
    "payer_plan_period": [
        ('payer_plan_period_id', 'int', True),
        ('person_id', 'int', True),
        ('payer_plan_period_start_date', 'dateonly', True),
        ('payer_plan_period_end_date', 'dateonly', True),
        ('payer_source_value', 'string', False),
        ('sponsor_source_value', 'string', False),
        ('plan_source_value', 'string', False),
        ('family_source_value', 'string', False),
        ('payer_concept_id', 'int', False),
        ('plan_concept_id', 'int', False),
        ('sponsor_concept_id', 'int', False),
        ('stop_reason_concept_id', 'int', False),
        ('payer_source_concept_id', 'int', False),
        ('plan_source_concept_id', 'int', False),
        ('sponsor_source_concept_id', 'int', False),
        ('stop_reason_source_value', 'string', False),
        ('stop_reason_source_concept_id', 'int', False)],

    "cost": [
        ('cost_id', 'int', True),
        ('cost_event_id', 'int', True),
        ('cost_domain_id', 'string', True),
        ('cost_type_concept_id', 'int', True),
        ('currency_concept_id', 'int', False),
        ('total_charge', 'float', False),
        ('total_cost', 'float', False),
        ('total_paid', 'float', False),
        ('paid_by_payer', 'float', False),
        ('paid_by_patient', 'float', False),
        ('paid_patient_copay', 'float', False),
        ('paid_patient_coinsurance', 'float', False),
        ('paid_patient_deductible', 'float', False),
        ('paid_by_primary', 'float', False),
        ('paid_ingredient_cost', 'float', False),
        ('paid_dispensing_fee', 'float', False),
        ('payer_plan_period_id', 'int', False),
        ('amount_allowed', 'float', False),
        ('revenue_code_concept_id', 'int', False),
        ('revenue_code_source_value', 'string', False),
        ('drg_concept_id', 'int', False),
        ('drg_source_value', 'string', False)],

    
    "drug_era": [
        ('drug_era_id', 'int', True),
        ('person_id', 'int', True),
        ('drug_concept_id', 'int', True),
        ('drug_era_start_date', 'dateonly', True),
        ('drug_era_end_date', 'dateonly', True),
        ('drug_exposure_count', 'int', False),
        ('gap_days', 'int', False)],

    "dose_era": [
        ('dose_era_id', 'int', True),
        ('person_id', 'int', True),
        ('drug_concept_id', 'int', True),
        ('unit_concept_id', 'int', True),
        ('dose_value', 'float', True),
        ('dose_era_start_date', 'dateonly', True),
        ('dose_era_end_date', 'dateonly', True)],

    "condition_era": [
        ('condition_era_id', 'int', True),
        ('person_id', 'int', True),
        ('condition_concept_id', 'int', True),
        ('condition_era_start_date', 'dateonly', True),
        ('condition_era_end_date', 'dateonly', True),
        ('condition_occurrence_count', 'int', False)],

    "concept": [
        ('concept_id', 'int', True),
        ('concept_name', 'string', True),
        ('domain_id', 'string', True),
        ('vocabulary_id', 'string', True),
        ('concept_class_id', 'string', True),
        ('standard_concept', 'string', False),
        ('concept_code', 'string', True),
        ('valid_start_date', 'dateonly', True),
        ('valid_end_date', 'dateonly', True),
        ('invalid_reason', 'string', False)],

    "vocabulary": [
        ('vocabulary_id', 'string', True),
        ('vocabulary_name', 'string', True),
        ('vocabulary_reference', 'string', True),
        ('vocabulary_version', 'string', False),
        ('vocabulary_concept_id', 'int', True)
    ],

    "domain": [
        ('domain_id', 'string', True),
        ('domain_name', 'string', True),
        ('domain_concept_id', 'int', True)
    ],

    "concept_class": [
        ('concept_class_id', 'string', True),
        ('concept_class_name', 'string', True),
        ('concept_class_concept_id', 'int', True)
    ],

    "concept_relationship": [
        ('concept_id_1', 'int', True),
        ('concept_id_2', 'int', True),
        ('relationship_id', 'string', True),
        ('valid_start_date', 'dateonly', True),
        ('valid_end_date', 'dateonly', True),
        ('invalid_reason', 'string', False)],

    "relationship": [
        ('relationship_id', 'string', True),
        ('relationship_name', 'string', True),
        ('is_hierarchical', 'string', True),
        ('defines_ancestry', 'string', True),
        ('reverse_relationship_id', 'string', True),
        ('relationship_concept_id', 'int', True)
    ],

    "concept_synonym": [
        ('concept_id', 'int', True),
        ('concept_synonym_name', 'string', True),
        ('language_concept_id', 'int', True)
    ],

    "concept_ancestor": [
        ('ancestor_concept_id', 'int', True),
        ('descendant_concept_id', 'int', True),
        ('min_levels_of_separation', 'int', True),
        ('max_levels_of_separation', 'int', True)],

    "source_to_concept_map": [
        ('source_code', 'string', True),
        ('source_concept_id', 'int', True),
        ('source_vocabulary_id', 'string', True),
        ('source_code_description', 'string', False),
        ('target_concept_id', 'int', True),
        ('target_vocabulary_id', 'string', True),
        ('valid_start_date', 'dateonly', True),
        ('valid_end_date', 'dateonly', True),
        ('invalid_reason', 'string', False)],

    "drug_strength": [
        ('drug_concept_id', 'int', True),
        ('ingredient_concept_id', 'int', True),
        ('amount_value', 'float', False),
        ('amount_unit_concept_id', 'int', False),
        ('numerator_value', 'float', False),
        ('numerator_unit_concept_id', 'int', False),
        ('denominator_value', 'float', False),
        ('denominator_unit_concept_id', 'int', False),
        ('box_size', 'int', False),
        ('valid_start_date', 'dateonly', True),
        ('valid_end_date', 'dateonly', True),
        ('invalid_reason', 'string', False)]
    
}








