# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
new_disease_cluster_county = dataiku.Dataset("svi_vulnerability_cluster_county")
df = new_disease_cluster_county.get_dataframe()


# Compute recipe outputs from inputs
df['State_County_code'] = df['State_County_code'].astype(str).apply(lambda x: '0'+x  if len(x)!=5 else x)

# Write recipe outputs
new_disease_format_county = dataiku.Dataset("cluster_county_format")
new_disease_format_county.write_with_schema(df)
