# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
svi_vulnerability_cdc_prepared = dataiku.Dataset("svi_vulnerability_cdc_scored")
df = svi_vulnerability_cdc_prepared.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Standardize FIPS, State and County codes to the right digit format
df['FIPS'] = df['FIPS'].astype(int)
df['FIPS'] = df['FIPS'].astype(str).apply(lambda x: '0'+x  if len(x)!=11 else x)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
final_df = df

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
svi_vulnerability_cdc_standardize = dataiku.Dataset("svi_vulnerability_cdc_standardize")
svi_vulnerability_cdc_standardize.write_with_schema(final_df)