import dataiku
import dataikuapi
import pandas as pd
from flask import request

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
disease_dataset = dataiku.Dataset("new_measure_name_tract").get_dataframe()


@app.route('/get_list')
def get_list():
    return json.dumps({"values": disease_dataset["Health_Measure"].values.tolist()})

@app.route('/get_variable')
def get_variable():
    recipe_filter = variables["standard"]["selected_measure_tract"]
    return json.dumps({"selected_measure_tract": recipe_filter})


@app.route('/set_variable', methods=["POST"])
def set_variable():
    selectedRecipe = request.get_json(force=True)
    variables["standard"]["selected_measure_tract"] = selectedRecipe["Health_Measure"]
    project.set_variables(variables)
    
    return json.dumps({"selected_measure_tract": selectedRecipe})
    


