[Metadata](flow_zone:ey5u0RV) flow zone provides information about the data structures across the project. There are two levels of data presented in the webapp and the analysis. On a tract level, the unique identifier consists of the 11-digit FIPS code. On a county level, a combination of county and state codes is needed for identifying records. Example:

 |    Code    |   Name | 
|------------|-------------------|
| 47117955000     | FIPS - Federal Information Processing Standards  |  
| 955000     | Tract Number |  
  | 117   | County Code  | 
  | 47   | State Code  | 
  
  
 Geographic and cartographic information for US county and tract areas are uploaded in [tl_geo_us_county](dataset:tl_geo_us_county) and [tl_geo_us_tract](dataset:tl_geo_us_tract). The files gathered from the  US Census Bureau that releases to the public extracts of the database in the form of [TIGER/Line Shapefiles](https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.2020.html#list-tab-IEYPBIOVNICXVKSG6R).

![Screenshot 2023-01-25 at 11.15.23.png](PmOaMTfrHUWf)

- [recipe_from_notebook_cansus_acs_data](recipe:recipe_from_notebook_cansus_acs_data) calls identifier features, geolocation and population data through the following API paths:
- ```f"https://api.census.gov/data/2020/acs/acs5/profile?get=NAME&for=state:*&key={census_api_key}"```

- Output Folders [state_to_county](managed_folder:vEodm51J) and [tracts_data](managed_folder:FC9VJvMv) store JSON files with geolocation information on the tract and county level.  ```state_county_options.json``` saves state - counties in a dictionary format with each state name is set as a ```key``` and the associated county names as ```values```. ``` state_codes_lookup.csv``` file is a lookup for the state and county codes and names. All the files fit the [social determinants of health](web_app:wRmlvsW) webapp as preprocessed data. 
 
- [compute_tracts_metadata_prep](recipe:compute_tracts_metadata_prep) calculates the ```Population_Density = Population / Area_sqmi``` on tract level. 