from flask import Blueprint, jsonify, request
from .python_lib.sdoh import SDOH, DataikuClient
import urllib3

urllib3.disable_warnings()

dataiku_client = DataikuClient()
sdoh = SDOH(dataiku_client=dataiku_client)


fetch_api = Blueprint("fetch_api", __name__)


@fetch_api.route("/api/get_state_counties")
def get_state_counties():
    return jsonify(sdoh.state_counties)


@fetch_api.route("/api/get_diseases")
def get_diseases():
    return jsonify(sdoh.diseases_client)


@fetch_api.route("/api/get_data", methods=["POST"])
def get_data():
    meta = request.get_json()
    return jsonify(sdoh.get_data(meta))


@fetch_api.route("/api/themes")
def get_themes():
    return jsonify(sdoh.themes_client)
