# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
import dataiku
from dataiku import pandasutils as pdu
import pandas as pd
import requests
import json

# custom function that can be found within Libraries tab > G+L
from census_api_functions import get_project_variables, get_query_text, state_name_list, get_tracts_code_table

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# variable specifications
census_api_key = get_project_variables('standard','api_key')
# census API variables specifications
census_code = 'DP05'
year = 2022

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# url path to call census API services
url_path = f"https://api.census.gov/data/{year}/acs/acs5/profile?get=NAME&for=state:*&key={census_api_key}"

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# numerical list of US states
state_nums_list = state_name_list(url_path)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# API request to gather the dataset from U.S. Census Bureau
all_tracts_df = pd.DataFrame()

for state in state_nums_list:
    print("state: " + state)
    try:
        state_all_tracts_query_url = f"https://api.census.gov/data/{year}/acs/acs5/profile?get=NAME,group({census_code})&for=tract:*&in=state:{state}&key={census_api_key}"
        state_all_tract_names_query_text = get_query_text(state_all_tracts_query_url)
        state_all_tract_names_query_result_list = json.loads(state_all_tract_names_query_text)
        state_all_tract_names_df = pd.DataFrame(state_all_tract_names_query_result_list[1:], columns=state_all_tract_names_query_result_list[0])
        df = state_all_tract_names_df.iloc[:, 1:]
        
        # Use pd.concat instead of append
        all_tracts_df = pd.concat([all_tracts_df, df], ignore_index=True)
    except Exception as e:
        print(f"Error processing state {state}: {e}")
        continue


# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# data preprocessing: column mapping, feature generation
all_tracts_df = all_tracts_df[['GEO_ID', 'DP05_0071E', 'DP05_0078E', 'DP05_0079E',
                                'DP05_0080E', 'DP05_0081E',
                               'DP05_0082E', 'DP05_0083E']]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
all_tracts_df.iloc[:, 1:] = all_tracts_df.iloc[:, 1:].astype(float)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
all_tracts_df['E_MINRTY'] = all_tracts_df.iloc[:, 1:].sum(axis=1)
all_tracts_df = all_tracts_df.drop(['DP05_0071E', 'DP05_0078E', 'DP05_0079E',
                                'DP05_0080E', 'DP05_0081E',
                               'DP05_0082E', 'DP05_0083E'], axis = 1)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
DP05_svi_tracts = dataiku.Dataset("DP05_svi_tracts")
DP05_svi_tracts.write_with_schema(all_tracts_df)