import dataiku
import dataikuapi
import pandas as pd
from flask import request

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
disease_dataset = dataiku.Dataset('svi_vulnerability_cdc_prepared_distinct').get_dataframe()


@app.route('/get_list')
def get_list():
    return json.dumps({"values": disease_dataset["Health Reason"].values.tolist()})

@app.route('/get_variable')
def get_variable():
    recipe_filter = variables["standard"]["selected_disease"]
    return json.dumps({"selected_disease": recipe_filter})


@app.route('/set_variable', methods=["POST"])
def set_variable():
    selectedRecipe = request.get_json(force=True)
    variables["standard"]["selected_disease"] = selectedRecipe["Health Reason"]
    project.set_variables(variables)
    
    return json.dumps({"selected_disease": selectedRecipe})
    


