Scenarios are set of actions to do, with condition(s) to run it. Dataiku automatically executes scenarios whose conditions are satisfied. Scenarios in this project are linked with [Project Variables](article:5) as a way of enabling user to direct the analysis in the Dashboards for a specified disease. 

![scenarios.png](4El8ghdpa6mx)


## [Flow Build - all prepackaged components](dashboard:3znBmzl)

To automatically build and run all the prepackaged components of this solutions you need to run recursively:
1. [Build Census CDC Base](scenario:BUILDWEBAPP) scenario builds the [flow zones](article:7) that call the input data ([Census Data - SVI factors](flow_zone:D8dQK96), [CDC Data](flow_zone:puo7jcP), [Metadata](flow_zone:ey5u0RV)), generates [data preprocessing and feature generation](flow_zone:9raboQY), scores the data using the [clustering](flow_zone:pZbFo92) pretrained model and activated the [social determinants of health webapp](web_app:wRmlvsW).

2.  [Regression Analysis](scenario:REGRESSIONANALYSIS) requires the Build Census CDC Base](scenario:BUILDWEBAPP) to be succesfully completed. This scenario builds the [Data Analytics / Modeling](flow_zone:sjc55sv) zone that scores the data for each disease by using the pretrained regression models (triggers [Regression models scenario](scenario:REGRESSIONMODELS)). The final zone of [Visual Insights](flow_zone:default) is completed and the [Disease Selection webapp](web_app:PxEkB0h) is activated. 

Upon smooth completion of both, the flow of this project is completely built and [Dashboards](article:8) present the webapps, ml- model explanations and charts from this work. 

##  Individual Components

1. [Regression models](scenario:REGRESSIONMODELS) recursively builds all the regression models as described in the relevant [article](article:22). The process includes update of the [Project Variables](article:5) with the name of a disease to [filter](recipe:compute_svi_vulnerability_cdc_by_disease) the data. It then activates the associate pretrained model (same as [activate_model_version](scenario:ACTIVATE_MODEL_VERSION) description below) and runs the recipe that scores the inpute data.

2. [activate_model_version](scenario:ACTIVATE_MODEL_VERSION) runs a python script that interacts with the  [saved disease models](saved_model:QOCx9pEZ) on the flow through the Dataiku API. Once a user selects a disease from the dropdown webapp in the [2. Chronic Disease Prevalence Modeling](dashboard:Nqzxt20) then the scenario maps the disease name to the associated model ID and activates the analysis of that version with the relevant explainability results from the Machine Learning Lab. 

3. Similarly  [Activate Model Version County](scenario:ACTIVATEMODELVERSIONCOUNTY) and [Activate Model Version Tract](scenario:ACTIVATEMODELVERSIONTRACT) activates the models that are associated with the health measure selected by user on [3. Social Determinants of New Health Measure - County](dashboard:q4kyVet) and [4. Social Determinants of New Health Measure - Tract](dashboard:RcBEWW5) respectively. 
 
4. [Update Dashboard](scenario:UPDATEDASHBOARD) runs the  [activate_model_version](scenario:ACTIVATE_MODEL_VERSION)  scenario and filters the data from the same disease in  [svi_vulnerability_cdc_prepared_filtered](dataset:svi_vulnerability_cdc_prepared_filtered) and [svi_vulnerability_cdc_windows](dataset:svi_vulnerability_cdc_windows) that generate and update a number of graphs in the summary results of the  [Chronic Disease Prevalence Modeling](dashboard:Nqzxt20).

## User Uploaded Data - Application Components

1. [DKU APP Update Visualisations](scenario:DKUAPPUPDATEVISUALISATIONS) for the prepackaged data on the application instance to enable user exploration and project demo in case of no new data upload. 

2. [DKU APP CHECK Schema Tract](scenario:DKUAPPCHECKSCHEMATRACT) and [Activate Model Version County](scenario:ACTIVATEMODELVERSIONCOUNTY) check that the schema of the uploaded files complies with the project required format and update the schema if needed. 

3. [DKU APP BUILD New Data Tract](scenario:NEWDATATRACT) and [DKU APP BUILD New Data County](scenario:NEWDATACOUNTY) rebuild and additional health measure uploaded by the user at tract and county level to generate the SDOH analysis. 

