# Version 2.1.0 - Patch Release - 2024-12
- Dashboards clean up.
- Case Study and Walkthrough.
- Updated data from Census and Places (CDC) to the latest available records of 2022. (See [Technical Limitations](article:25))
- Updated code environment with new package versions. (see [Technical Requirements](article:10))
- Updated URL path to access Census API for Census code: S1701, S0601, S2503, S0101, S2701.
- Updated the code that queries data from Socrata to exceed the API request limits. Added a pagination mechanism to handle Socrata API limits by iteratively fetching data in chunks using the ```limit``` and ```offset``` parameters, ensuring all records are retrieved. This replaces the single large query with a dynamic loop that appends data until all rows are collected, while maintaining the original script’s functionality for processing and saving the data.

# Version 2.0.5 - Patch Release - 2024-02
- Technical requirements bug fixed.

# Version 2.0.4 - Patch Release - 2024-01
- Typo fixed.
- Segmentation graph labels updated.

# Version 2.0.3 - Upgrade Release - 2023-11
- Project libraries updated for cloud availability.
- Replace recipe "compute_new_condition_scored_tract_prepared" with code in [compute_new_condition_tract_format](recipe:compute_new_condition_tract_format) for memory efficiency purposes.
- Updated the solution template to align with latest Dataiku Business Solution format. 
- Updated code env to python3.8 and changed the code env name to ```solution_soc-determinants-health```

# Version 2.0.2 - Patch Release - 2023-05
- Updated the webapp displays for Social Vulnerability Themes.

# Version 2.0.1 - Patch Release - 2023-04
- Fixed typo in dashboard name.
- Rerun Visul Analysis for regression models to ensure that uses can access the design and results. 
- Updated geometries algorithms to prevent webapp timeout and high memory consumption. ```topojson``` is used to simplify the geometries while preserving the topology structure for each location. 

# Version 2.0.0 - Upgrade Release - 2023-04
- Computed [Segmentation Analysis (County)](flow_zone:oAQdaOx) to complement the final results and analysis. 
- Created a new section to serve user's newy uploaded data at county and trat level. The following part comes with prepackaged data for ```Health Measure: Depression and Covid Vacc Primary Series```. New zones include: [New Health Measure](flow_zone:heQgGfe), [New Measures Preprocessing Tract](flow_zone:zqQFi9z), [New Health Measures Preprocessing County](flow_zone:GdzvDSX), [New Health Measures Data Analytics/Modelling Tract](flow_zone:C46so1N), [New Health Measures Data Analytics/Modelling  County](flow_zone:ETKLRJe), [New Health Measures Visualizations Tract](flow_zone:jkilkC0), [New Health Measures Visualizations County](flow_zone:hWxPdgy), [Unique Health Measures](flow_zone:ucVL6kF).
- Developed two new standard webapps for updating visualisations [Health Measure Selection County Level](web_app:5OXSkG3) and [Health Measure Selection Tract Level](web_app:PxEkB0h).
- Rearranged dashboards: [Health Equity Wehapp](dashboard:gybGMoE) hosts the published [social determinants of health](web_app:wRmlvsW) webapp and [3. Social Determinants of New Health Measure - County](dashboard:q4kyVet) and[4. Social Determinants of New Health Measure - Tract](dashboard:RcBEWW5) dashboards are created to update the analysis of newly uploaded data. 
- Updated [0. User Manual - Solution Build](dashboard:3znBmzl) with extended project functionality instructions. 
- A dataiku application is now built on top of this solution with a user interactive interface. 



# Version 1.2.0 - Upgrade Release - 2023-02

- Updated [python metadata recipe](recipe:compute_FC9VJvMv) to simplify the geometry vectors using the [shapely](https://shapely.readthedocs.io/en/stable/manual.html) package.
- Added a ```disease prevalence``` filter on the [social determinants of health webapp](web_app:wRmlvsW).

# Version 1.1.0 - Upgrade Release - 2023-01

 - Updated [Metadata](dataset:tracts_metadata_prep) datasource to [TIGER/Line](https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.2020.html#list-tab-IEYPBIOVNICXVKSG6R) Shapefiles from Census.
 - Increase of records within [social determinants of health](web_app:wRmlvsW) Webapp shows increa of loading time in the dashboard.
 - Python code cleaning with extra comments and code libraries reusability.
 - [Build Webapp](scenario:BUILDWEBAPP) Scenario updated. 
 

# Version 1.0.0 - Initial Release - 2022-12