## Case Study: Prioritizing Depression Prevention in New Jersey Using Dataiku's Social Determinants of Health Solution

This case study demonstrates how an organization supporting social programs can use Dataiku's Social Determinants of Health (SDoH) solution to strategically allocate funds for health condition prevention and intervention.

### Program Background
The New Jersey Wellbeing Hub seeks to address mental health disparities statewide by prioritizing counties with high depression rates and elevated social vulnerability. Depression is notably prevalent in areas where socioeconomic challenges exacerbate mental health risks. With limited resources, the organization aims to use data-driven insights to target funding more effectively and maximize impact. By leveraging Dataiku's SDoH solution, the hub can identify high-risk areas, understand the socio-economic drivers of depression, and allocate funds where they are most needed.

### Initial Situation
**Current Funding and Planning Challenges:**
- Limited insight into the distribution and underlying drivers of depression across counties.
- Allocation strategies lack precision, leading to under-resourcing in high-risk areas.
- Broad, generalized approach to mental health interventions, with limited focus on the most vulnerable regions.

**Data Sources**
To address these challenges, the organization integrates several key data sources:
- **CDC Depression Rates**: Tract and County-level data on depression prevalence.
- **Social Vulnerability Index (SVI)**: U.S. Census data on socio-economic factors that impact health, including income, employment, education, housing, and access to healthcare.
- **Community Demographics**: Census demographic data contextualizes social vulnerability, allowing a deeper understanding of each community's characteristics.

### Goals
The hub’s primary objectives are to:
- **Prioritize High-Risk Locations**: Use social vulnerability and depression data to target areas where socio-economic conditions are linked with increased depression risk.
- **Identify Key Social Factors**: Determine which socio-economic conditions most strongly correlate with high depression rates.
- **Optimize Fund Allocation**: Use insights from Dataiku's SDoH solution to allocate funds effectively for mental health resources in prioritized areas.

### Insights and Analytics
Dataiku's SDoH solution provides actionable insights through various analytics, helping the team understand mental health needs across New Jersey and prioritize funding appropriately. The solution offers an accessible setup to explore both pre-packaged data and uploaded user records.
![0.png](R6RMUJnXVmzd)

#### **County-Level Social Determinants Profiles**
The solution generates detailed profiles for each county and tract accross the US, offering a comprehensive view of depression risk factors across New Jersey. These profiles highlight unique socioeconomic challenges by county, enabling the team to tailor funding strategies based on local needs. For example, profiles may reveal that Salem County has both high depression prevalence and high social vulnerability, allowing the hub to plan targeted interventions.
![1.png](rR5A1u0LRjiw)
![2.png](xHktkbndtXOW)
#### **Social Vulnerability and Depression Segmentation**
The dashboard shows segmentation of Census records based on the percentile values of 16 socioeconomic factors at the tract level, categorizing communities by low, mid, and high social vulnerability. Patterns emerge, showing factors like poverty rates, minority status, and educational attainment as key drivers of health disparities. This segmentation enables the team to concentrate on areas where socioeconomic conditions most heighten mental health risks.
![3.png](J1QVmTtaqUdx)
Moreover, the dashboard displays the distribution of depression rates across different levels of social vulnerability. The insights reveal that depression affects a diverse range of backgrounds, highlighting that mental health conditions are complex and widespread. These clusters help the team focus on regions with both heightened vulnerability and unmet needs.
![4.png](XNW7VWJg1H6f)
#### **Predictive Insights for Fund Allocation**
Regression models within the solution provide insights into the relationship between depression prevalence and social factors. SHAP values increase interpretability by showing the positive or negative influence of each factor on depression prevalence at the local level. While this is not causal analysis, it does indicate which factors most impact the prediction model’s accuracy for each tract. This insight supports targeted resource planning based on the most influential social factors per location.
![5.png](4MhJng5vZWWq)
### Business Impact
By implementing Dataiku's Social Determinants of Health solution, New Jersey’s Wellbeing Hub can:
- **Identify High-Need Areas**: Pinpoint counties with the greatest need for mental health resources based on depression prevalence and social vulnerability indices.
- **Tailor Interventions to Local Needs**: Design intervention strategies that address the specific socioeconomic drivers of depression in each location.
- **Enable Continuous Monitoring**: With Dataiku’s reproducible and automated data workflows, the organization can track and adjust its approach as social conditions and depression rates evolve.

### Conclusion
With Dataiku’s SDoH solution, New Jersey’s Wellbeing Hub has transformed its approach to mental health funding from a generalized model to a targeted, data-driven strategy. By integrating real-time social and health data, Dataiku’s SDoH solution empowers the organization to allocate resources strategically, address socioeconomic factors contributing to depression, and drive meaningful improvements in mental health outcomes across the state.
