def generate_numbers_clusters(min_nb: int=3, max_nb: int=7, count_nb_clusters: int=3):
    """
    Generate the number of clusters from a min-max range for the kmeans algorithm.
    
    :param min_nb: int: Minimum number of clusters
    :param max_nb: int: Maximum number of clusters.
    :param count_nb_clusters: int: Count of different numbers of clusters in the range.

    :return n_clusters: List[int]: List of the different numbers of clusters in the range. 

    """

    interval = (max_nb - min_nb) / (count_nb_clusters - 1)
    n_clusters = [min_nb + round(i * interval) for i in range(count_nb_clusters-1)]
    n_clusters.append(max_nb)  # Append max_nb separately to ensure it's exactly included
    return n_clusters
