import warnings 
from dku_commons.dku_utils.type_checking import DSSProject, check_object_is_project
from collections import Counter


def check_duplicated_aggregations(project, local_variables):
    segmentation_strategies = local_variables["segmentation_strategies"]

    if "demographic_segmentation" in segmentation_strategies:
        if (("sums" in local_variables["census_numerical_aggregation_type"])
           and ("averages" in local_variables["census_numerical_aggregation_type"])
           and (local_variables["census_numerical_aggregation_sum_settings"]=="explicitly_select_columns_to_sum")
           and (local_variables["census_numerical_aggregation_average_settings"]=="explicitly_select_columns_to_average")):

            for col in local_variables["census_numerical_columns_to_sum"]:
                if col in local_variables["census_numerical_columns_to_average"]:
                    log_message = f'Please note: for reasons of interpretability, '\
                                    'it is not recommended to aggregate ' +col+ ' by both summing and calculating the average.'
                    raise Exception(log_message)
        
        if (("count" in local_variables["census_categorical_aggregation_type"])
           and ("ratio" in local_variables["census_categorical_aggregation_type"])
           and (local_variables["census_categorical_aggregation_count_settings"]=="explicitly_select_columns_to_apply_count_on")
           and (local_variables["census_categorical_aggregation_ratio_settings"]=="explicitly_select_columns_to_apply_ratio_on")):

            for col in local_variables["census_categorical_columns_to_count"]:
                if col in local_variables["census_categorical_columns_to_apply_ratio_on"]:
                    log_message = 'Please note: for reasons of interpretability, '\
                                    'it is not recommended to aggregate ' +col+ ' by both counting and applying a ratio on it.'
                    raise Exception(log_message)

def check_variables_settings(project, local_variables):
    
    segmentation_strategies = local_variables["segmentation_strategies"]
    
    if "sales_per_category_segmentation" in segmentation_strategies:
        if local_variables["sales_per_category_aggregation_type"] == "compute_percentage_of_total_sales_per_category" and len(local_variables["categories_to_focus_on"])==1:
            log_message = 'As you have selected "Percentage sales per category", '\
            'it is mandatory to select at least 2 categories.'
            raise Exception(log_message)
    
    if len(segmentation_strategies) == 0:
        log_message = 'Please, select at least one segmentation strategy in order to, '\
        'analyse your data with the Store Segmentation Solution.'
        raise Exception(log_message)
    
def check_schema(project: DSSProject, dataset_name: str, schema_to_have: list):
    """
    Checks if the schema of a dataset respects the data model.
    
    :param project: DSSProject: A handle to interact with a project on the DSS instance.
    :param dataset_name: string: Name of the dataset whose schema must be checked.
    :param schema_to_have: list: List of the data model column names.
    """
    
    check_object_is_project(project)
    dataset = project.get_dataset(dataset_name)
    current_schema = []
    for col in dataset.get_schema().get('columns'):
        current_schema.append(col.get('name'))

    if Counter(current_schema) != Counter(schema_to_have):
        log_message = f'The schema of {dataset_name} ({current_schema}) is not respecting the data model. Please check the data model.'
        raise Exception(log_message)
        