# -*- coding: utf-8 -*-
import dataiku
import pandas as pd
import numpy as np

from dku_commons.dates_handling.type_conversions import from_datetime_to_dss_string_date
from dku_commons.dates_handling.computations import compute_date_time_granularity, simplify_date
from dku_commons.dku_utils.projects.project_commons import get_current_project_and_variables
from solution.constants import APP_DATE_COMPONENTS_TO_REMOVE

project, variables = get_current_project_and_variables()

global_variables = variables["standard"]
batch_start_date = global_variables["batch_start_date_app"]
batch_end_date = global_variables["batch_end_date_app"]
transactions_time_granularity = global_variables["transaction_time_granularity_app"] #["days", "weeks", "months", "quarters"]

batch_dates = list(pd.date_range(start=batch_start_date, end=batch_end_date))

batch_dates = [date.to_pydatetime() for date in batch_dates] # convert every date in batch_dates to datetime

dates_time_granularities = [compute_date_time_granularity(date, transactions_time_granularity)
                            for date in batch_dates]

# give the week number of the date in batch_dates
# '2020-week-6', '2020-week-7', '2020-week-7',...

batch_dates = [from_datetime_to_dss_string_date(simplify_date(date, APP_DATE_COMPONENTS_TO_REMOVE)) for date in batch_dates]
batch_dates_df = pd.DataFrame(batch_dates, columns=["transaction_date"])
batch_dates_df["time_granularity"] = dates_time_granularities

INFER_SCHEMA = False
DROP_AND_CREATE = True
dataiku.Dataset("batch_dates_granularities").write_dataframe(batch_dates_df,
                                                             INFER_SCHEMA,
                                                             DROP_AND_CREATE)
