# -*- coding: utf-8 -*-
import dataiku
from dku_commons.dku_utils.projects.datasets.dataset_commons import get_dataset_schema_information
from solution.utils.pandas_utils import compute_dataframe_columns_ratio
from dku_commons.dku_utils.projects.project_commons import get_current_project_and_variables

project, _ = get_current_project_and_variables()

# Get input dataset as a Dataframe
dataset_columns, dataset_column_datatypes = get_dataset_schema_information(project, "stores_sales_per_product_category_sum")
dataset_to_ratio = dataiku.Dataset("stores_sales_per_product_category_sum")
dataset_to_ratio_df = dataset_to_ratio.get_dataframe()

# Define the columns to compute ratio on
columns_to_compute_ratio_on = []
for column_name in dataset_columns:
    if column_name not in ['store_id']:
        columns_to_compute_ratio_on.append(column_name)

output_dataset_df = compute_dataframe_columns_ratio(dataset_to_ratio_df, columns_to_compute_ratio_on,
                                                    "^(.*?)_sum$", "_ratio", 
                                                    remove_initial_sum_count=True, remove_total_column=True)

# Write recipe outputs
output_dataset = dataiku.Dataset("stores_sales_per_product_category_ratio")
output_dataset.write_with_schema(output_dataset_df)
    