# Introduction

This dashboard is updated each time the sales per category branch is executed, thanks to the [update_sales_per_category_dashboard](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) scenario. Throughout this article, any reference to a scenario refers to this one. 

<div class="alert">
Please be aware that some of the charts are updated thanks to the Dataiku API (through the scenario linked above). The concerned charts are annotated with a warning comment saying "<i>The content of this tile is generated by a scenario<i>". <b>Any manual modification of the content of these charts may not be taken into account if the scenario is executed.<b>
</div>

When you first open the Dashboard, you will see a global presentation of the Sales per Category Segmentation and an explanation of what this segmentation means. On the left side of it, if you run the other segmentation strategy, a link button can redirect you to the other Dashboard. This button has been generated by the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD). Therefore, any manual modification of the content of this text box may not be taken into account if the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) is executed.

![category dashboard title and button.png](ZTaGstxA5qrR)

On the left, you can find a little reminder of the **category(ies)** being analyzed, as well as the **transaction time period**. These have been selected in the Project Setup and the text box is updated thanks to the third step of the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD). Therefore, any manual modification of the content of this text box may not be taken into account if the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) is executed. 

You can also view the **number of stores** being analyzed, the **number of clusters**, and the **total revenue of all your stores**. Another box invites you to begin the analysis by exploring the **Store Cluster Analysis** first.

![category recal - metrics - title.png](5LWr17zcXXDy)

# Store Cluster Analysis
## Where? How many? How much?

In this section, you can explore the **locations** of each store with its cluster color code on the map. You can **filter** by store or cluster and analyze the **number of stores** and **total revenue by cluster**. Note that the filters are applied to the entire page, and is updated by the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) as well. Since the data model of the [products](dataset:products) dataset allows for an unlimited number of sub_category_2 and additional subcategories, the fourth step of the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) adds or removes these columns according to the input dataset.

![store cluster analysis.gif](L0WMlXUn3Wbr)

## What are the sales trends by cluster over time?

In the next chart, you can see how much each cluster sells over time and compare it to the total revenue of all clusters (or stores).

![revenue trends by cluster.png](DbiSYLwZbt5h)

# Category and Sub-Category Level Analysis

This section of the Dashboard focuses on the analysis of the categories and sub-categories. The sub-categories are denoted as `sub_category_1`, `sub_category_2`, etc., with the first being the highest level under the `target_category` level. For example, a `target_category` can be _WOMEN_ for women's clothes, then a `sub_category_1` can be _DRESSES_, and a `sub_category_2` can be _PARTY_DRESSES_. You can check the [products](dataset:products) dataset to understand the structure.

![category and sub category title.png](3FRRTCP4tfP9)

## How are my category(ies) sales distributed per cluster?

In this section, you can first find a chart showing the **distribution of the category sales per cluster** . The columns on the y-axis of this chart, as well as the type of the chart (Vertical stacked bars 100%) are updated thanks to the fifth step of the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD).

![category sales distribution per cluster.png](0Pa75N9k5l44)

If just one category has been selected, then a chart looking below will be displayed. Again, this is updated thanks to the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD): the category column is used for the y-axis and the chart is set as a Vertical stacked bars normal instead of Vertical stacked bars 100%.

![one category sales distribution .png](3A18jvbpeVnl)

## What about the sales trends of my category(ies) over time?

Here is a chart where you can analyze the **sales trends of your category(ies) over time**. The granularity on this chart depends on what you have selected in the Project Setup.

![revenue trends by category.png](5PXm4EmQqISZ)

![transaction granularity.png](hIks312wRY0h)

## How well are my sub-categories performing?

Then, you can analyze each **sub-category's performance by cluster** on a **radar chart**. If there are multiple sub-category levels in the [products](dataset:products) dataset, this radar focuses on the smallest sub-category level. As the smallest sub-category level depends on the [products](dataset:products) dataset, the last step of the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) updates its "By" column. Any manual modification of the content of this chart may not be taken into account if the [scenario](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD) is executed.

![radar chart.png](wYmzoPaJjntT)

## Deep dive into a sub-category performance ranking, by cluster

![sub category performance ranking by cluster.gif](h0fNenqW4B8S)

For more details about the **sales performance at each category and sub-category level**, this table provides insights about:
- sub-category **revenue**
- sub-category **number of transactions**
- sub-category **number of sold items**
- sub-category **sales per transaction**
- sub-category **sales per item**
- all of these **ranked by revenue**

Sales per transaction is calculated by dividing the sub-category revenue by the number of transactions. Sales per item is calculated by dividing the sub-category revenue by the number of sold items.

On the very left of the table, you can see the clusters, which you can filter using the filter on the left side panel of the page. 

The `target_category` column reminds you of the main category. 

Following this, the table columns are organized by sub-category, from the highest to the lowest sub-category level from left to right. Scroll to the right to see the lowest sub-category metrics. Note that duplicated values for `sub_category_1`, for example, are due to different values for `sub_category_2`.

# Product Level Analysis
## What are my best and worst-selling products?

Finally, you can analyze at a product level with these two tables. 
The first table shows the **top 5 performing products** for each cluster in each target category.
The second table shows the **bottom 5 performing products** for each cluster in each target category.
For both tables, you can check the **product revenue** and the **product revenue share within the target category**.

![product level analysis.png](gXOFpCEqZyHP)