In this solution, we can identify four different types of scenarios:

- Project Setup Scenarios
- Input Preprocessing Scenarios
- Demographic Branch Scenarios
- Sales per Category Branch Scenarios

# Project Setup Scenarios

![project set up scenarios.png](q2kU4AFTWUKg)

- **[get_first_and_last_transaction_dates](scenario:GET_FIRST_AND_LAST_TRANSACTION_DATES)**: Retrieves the first and last transaction dates available in the [transactions](dataset:transactions) dataset.
- **[load_application_variables](scenario:LOAD_APPLICATION_VARIABLES)**: Updates global variables by copying from the local variables. This scenario is called each time any scenario is executed.
- **[load_store_segmentation_datasources](scenario:LOAD_STORE_SEGMENTATION_DATASOURCES)**: Loads the datasets from the data preparation project into Store Segmentation.
- **[reconfigure_flow_connections_settings](scenario:RECONFIGURE_FLOW_CONNECTIONS_SETTINGS)**: Changes the connections settings of all datasets in the Flow.

# Input Preprocessing Scenarios

![inputs preprocessing scenarios.png](Cn1WNaRczhIv)

- **[build_inputs](scenario:BUILD_INPUTS)**: Calls the [load_store_segmentation_datasources](scenario:LOAD_STORE_SEGMENTATION_DATASOURCES) and [build_store_preprocessing](scenario:BUILD_STORE_PREPROCESSING) scenarios. This scenario is executed when pressing the `RUN NOW` button in the `Data Loading and Store Preprocessing` part of the Project Setup:
  ![build inputs button.png](NUW1KX2e3Ms5)
- **[build_store_preprocessing](scenario:BUILD_STORE_PREPROCESSING)**: Runs the [store_preprocessing](flow_zone:Um5gJ7R) Flow Zone and updates the [compute_distinct_stores_prepared](recipe:compute_distinct_stores_prepared) Python recipe.
- **[build_transactions_preprocessing](scenario:BUILD_TRANSACTIONS_PREPROCESSING)**: Runs the [transactions_preprocessing](flow_zone:dMGG99Q) Flow Zone and updates some recipes.
- **[compute_batch_dates_boundaries](scenario:COMPUTE_BATCH_DATES_BOUNDARIES)**: Gets the first and last transaction dates for the [compute_batch_dates_granularities](recipe:compute_batch_dates_granularities) Python recipe and is called in the [build_transactions_preprocessing](scenario:BUILD_TRANSACTIONS_PREPROCESSING) scenario.

# Demographic Branch Scenarios

![demographic scenarios.png](mjBIaBZIv5O6)

- **[compute_demographic_segmentation_branch](scenario:COMPUTE_DEMOGRAPHIC_SEGMENTATION_BRANCH)**: Runs the whole demographic segmentation branch. This scenario calls all the scenarios below.
- **[build_store_trade_area_preprocessing](scenario:BUILD_STORES_PREPROCESSING)**: Runs the [store_trade_area_preprocessing](flow_zone:SGiYzxu) Flow Zone and updates the recipes and datasets to the trade area computation method.
- **[build_demography_feature_engineering](scenario:BUILD_DEMOGRAPHY_FEATURE_ENGINEERING)**: Runs the [demography_feature_engineering](flow_zone:7yZk0IS) Flow Zone and updates the recipes and datasets to the demographic aggregation methods.
- **[build_demographic_segmentation](scenario:BUILD_DEMOGRAPHIC_SEGMENTATION)**: Runs the [demographic_segmentation](flow_zone:exvvEME) Flow Zone and updates the clustering model settings.
- **[build_demographic_dashboard_preparation](scenario:BUILD_DEMOGRAPHIC_DASHBOARD_PREPARATION)**: Runs the [demographic_dashboard_preparation](flow_zone:GtZ2u0R) Flow Zone to update the recipes and datasets.
- **[update_demographic_dashboard](scenario:update_demographic_dashboard)**: Updates some of the charts, filters, and text boxes in the Demographic Dashboard. You can find about its impact on the dashboard in the [Demographic - Segmentation Results](article:30) article.

# Sales per Category Branch Scenarios

![sales per category scenarios.png](0YI6NV9OHmN8)

- **[compute_sales_per_category_segmentation_branch](scenario:COMPUTE_SALES_PER_CATEGORY_SEGMENTATION_BRANCH)**: Runs the whole sales per category segmentation branch. This scenario calls all the scenarios below.
- **[build_transactions_feature_engineering](scenario:BUILD_TRANSACTIONS_FEATURE_ENGINEERING)**: Runs the [transactions_feature_engineering](flow_zone:6GCmqd3) Flow Zone and updates the recipes and datasets to the transaction aggregation method.
- **[build_sales_per_category_segmentation](scenario:BUILD_SALES_PER_CATEGORY_SEGMENTATION)**: Runs the [sales_per_category_segmentation](flow_zone:hjoEdjT) Flow Zone and updates the clustering model settings.
- **[build_sales_per_category_dashboard_preparation](scenario:BUILD_SALES_PER_CATEGORY_DASHBOARD_PREPARATION)**: Runs the [sales_per_category_dashboard_preparation](flow_zone:QpVLY0r) Flow Zone and updates the recipes and datasets.
- **[update_sales_per_category_dashboard](scenario:UPDATE_SALES_PER_CATEGORY_DASHBOARD)**: Updates some of the charts, filters, and text boxes in the Sales per Category Dashboard. You can find about its impact on the dashboard in the [Sales per Category - Segmentation Results](article:11) article.