Here are the requirements and instructions to run the solution:

The solution runs on Dataiku **12.6 and above**.

# Code Environment
No specific code environment is needed.

# Plugin Requirements
The [Geo Router plugin](https://www.dataiku.com/product/plugins/geo-router/) must be installed on the instance running the solution. 

To install the plugin:
1. Open the Apps menu on the top right corner of the page.
2. Click Plugins and search for Geo Router.
3. Alternatively, you can download a zipped version [here](https://cdn.downloads.dataiku.com/public/dss-plugins/georouter/?_gl=1*f0eq38*_ga*NDUwMjMxNjU2LjE2ODgzODM4MTU.*_ga_B3YXRYMY48*MTcxODI5NDAyMy4yNzcuMS4xNzE4Mjk0MDM0LjQ5LjAuMA..).

# Data storage requirements
The ***Store Segmentation***  Project Setup is designed to work with SQL storage.
To benefit natively from the solution, your data (see Data Requirements) should be stored in one of the following connections:
- Snowflake
- Filesystem managed connection (the Solution comes with demo data on this connection)

# Data Preparation

Follow the steps below to prepare your data to fit the [data model](article:15).

## Scenario A: You Already Have Datasets Fitting the Data Model

1. **Create a new project with an explicit name.**

     ![create project.png](MJhEcwJUcJTB)
     ![give a name.png](3Z9JsVZfhOFH)

2. **Upload your data table from your files or from other Dataiku projects.**

     ![upload data table.png](DCxnBKHy5Tp0)

3. **Connect your uploaded dataset to a connection using the Sync Recipe (choose Filesystem for testing).**

     ![sync recipe.png](uZjWp72S1zRm)

4. **Copy the Data Preparation Project Key.**

     ![project key 2.png](1TzKE3ZyUYsN)

5. **You are now ready to go to the Project Setup page and start using the Solution!**
<br><br>

## Scenario B: You Don't Have Datasets Fitting the Data Model Yet

1. **Create a new project with an explicit name.**

     ![create project.png](MJhEcwJUcJTB)
     ![give a name.png](3Z9JsVZfhOFH)

2. **Upload the necessary data to start the preparation.**

3. **Work on your data to fit the [data model](article:15).**

4. **Once the datasets fit the data model, connect your datasets to a connection (choose Filesystem for testing).**

5. **Copy the Data Preparation Project Key.**

     ![project key 2.png](1TzKE3ZyUYsN)

6. **You are now ready to go to the Project Setup page and start using the Solution!**