# User Story

As a **Category Manager** working for Waving, a surf attire company with multiple stores along the English coast, you are responsible for the product category "**MEN**" and need to **reassort products in all the stores**. To improve efficiency, you aim to **take actions on similar stores simultaneously**, such as sending more MEN category products to stores with high sales in these items.

To achieve this, you might ask: "**In which store should I distribute which products to meet customer demands and preferences?**"

You can answer this question using Store Segmentation, a Solution that groups stores based on demographic and sales data. There are 2 segmentation strategies available:
- Demographic Segmentation
- Sales per Category Segmentation

You might need a data scientist's help to initially set up and run the Solution. After that, you can view the [Demographic Segmentation](dashboard:nR8JBzQ) and [Sales per Category Segmentation](dashboard:JiM4DuH) dashboards to start your analysis.

# Data

To use this Solution, you need at least 2 datasets:
1. **Stores**: Provides store locations in latitude and longitude.
2. **Transactions**: Contains transaction information such as the store, date, product bought, product purchase price, and quantity bought.

If you want to use the demographic segmentation, you need **census data** with the following information:
- Age
- Gender
- Nationality
- Occupation or Employment
- Income
- Workplace
- Household Composition

If you want to use the sales per category segmentation, you need a **products** dataset. This dataset lists all the products from your target category and tags them with their associated sub-categories.

For more details about the data model, please read this [Data Model article](article:15) or check out the datasets:
- [stores](dataset:stores)
- [transactions](dataset:transactions)
- [census_data](dataset:census_data)
- [products](dataset:products)

# Value and Benefits

With this Solution, you will be able to:
- Differentiate your product assortment to drive sales by offering the right items in the right catchment areas based on consumer preferences and demand.
- Establish price zones and make price-zoning decisions that align with strategic goals for unique store clusters.
- Understand localized demand for better space allocation decisions, improving customer satisfaction and loyalty, and increasing sales revenue.