This [store_trade_area_preprocessing](flow_zone:SGiYzxu) Flow Zone marks the beginning of the **demographic segmentation branch**.

In order to perform store segmentation based on demographic information, we need to join the store data with the census data. Census data is collected by small areas, all of which cover the entire country. To join both datasets, we create a trade area around each store (which can be defined by the user in the Project Setup) and join where the trade area and census areas overlap. Generally, census areas are smaller than the trade area.

The goal of this Flow Zone is to create a trade area for each store.

At this point in the Flow, the [stores_with_geopoint](dataset:stores_with_geopoint) dataset has, for each store, the latitude, longitude, and a geopoint. The creation of the trade area can be performed in two ways:

- **By distance**: We use a Prepare recipe, [compute_store_trade_areas](recipe:compute_store_trade_areas), with the `Create area around geopoint` step. This is what the Flow Zone looks like when computing the trade area by distance. Note that the Geo Router plugin is not used in this scenario.
![store trade area distance.png](X8Y2vgxIs02K)

- **By time travel**: We use the `Compute isochrone` recipe from the [Geo Router](https://www.dataiku.com/product/plugins/geo-router/) plugin. Thanks to this plugin, we can create isochrones (trade areas) around stores using a geopoint, a maximum travel time, and a transportation mode (either car, bicycle, or pedestrian). Then, in the [compute_store_trade_areas](recipe:compute_store_trade_areas) prepare recipe, we rename the new column `isochrone` to `store_trade_area`. This is what the Flow Zone looks like when computing the trade area by time travel:
![store trade area time travel.png](JhOyoxHl5ObV)

Thus, the final dataset [store_trade_areas](dataset:store_trade_areas) contains the trade area for each store.

