# Introduction

This dashboard is updated each time the sales per category branch is executed, thanks to the [update_demographic_dashboard](scenario:update_demographic_dashboard) scenario. Throughout this article, any reference to a scenario refers to this one. 

<div class="alert">
Please be aware that some of the charts are updated thanks to the Dataiku API (through the scenario linked above). The concerned charts are annotated with a warning comment saying "<i>The content of this tile is generated by a scenario<i>". <b>Any manual modification of the content of these charts may not be taken into account if the scenario is executed.<b>
</div>

When you first open the Dashboard, you'll see a global presentation of the Demographic Segmentation, explaining _What does this segmentation mean?_. On the left side of it, if you run the other segmentation strategy, a link button can redirect you to the other Dashboard. This button has been generated by the second step of the [scenario](scenario:update_demographic_dashboard). Therefore, any manual modification of the content of this text box may not be taken into account if the [scenario](scenario:update_demographic_dashboard) is executed.

![demog dashbaord title.png](yC1XDfyPvvcO)

On the left, you can review the **trade area computation method** that has been chosen, as well as the **transaction time period**. These have been selected in the Project Setup and the text box is updated thanks to the third step of the [scenario](scenario:update_demographic_dashboard). Therefore, any manual modification of the content of this text box may not be taken into account if the [scenario](scenario:update_demographic_dashboard) is executed.

Then, you can view the **number of stores** you are analyzing, the **number of clusters**, and the **total revenue of all your stores** (with the currency chosen in the Project Setup, and updated thanks to the fourth step of the [scenario](scenario:update_demographic_dashboard)). 

Another box invites you to begin the analysis by exploring the **Store Cluster Analysis** first.

![demographic segmentation metrics.png](hYK1i27vnJfL)

# Store Cluster Analysis

_Note: If you want to **modify the colors** of the clusters, please also change **the palette in the library** (/python/solution/constants.py, line 1) so that the color of the text in the **Cluster Identity Card** is also changed. _

## What makes up my clusters?

In this section, you can explore the **locations** of each store on the map, with its cluster color code. You can also **filter** by store or cluster and analyze each **cluster’s specificities** using the **Cluster Identity Card**. Note that the filters are applied to the entire page, and its values are updated by the [scenario](scenario:update_demographic_dashboard) as well. 

![demographic map.gif](dupC3hjTWzob)

The **Cluster Identity Card** has been generated by the fifth step of the [scenario](scenario:update_demographic_dashboard). The text colors corresponds to the original palette available in the library (/python/solution/constants.py, line 1). These colors are set each time the [scenario](scenario:update_demographic_dashboard) is run. If you filter by cluster, then, the color of the text won't dynamically be modified. 

## How many stores by cluster? Population by cluster? What revenue by cluster?

In the next chart, you can see the number of stores, the population, and the total revenue by cluster.

![demographic store pie chart.png](0eDGjQUptILF)

# Population Characteristics

This section of the Dashboard focuses on the analysis of the population within each trade area. You can find one chart for each type of census information:
- Gender
- Nationality
- Age
- Occupation or Employment
- Income
- Workplace
- Household Composition

In each chart of this section, the columns in the y-axis are updated by the last steps of the [scenario](scenario:update_demographic_dashboard). In fact, depending on the aggregation type chosen in the Project Setup, either "Sum" or "Percentage", the name of the columns on the y-axis are not the same.

![population characteristics.png](L5RxmpVoaPlF)
![population age and nationality.png](4mHbYCfSvlc0)
![population occupation and income.png](wHgflsmTQSPp)
![population workplace and household composition.png](fGWes1BLG5jS)

# Demographic Snapshot

If you want to get more details for each trade area around each store, you can read the Demographic Snapshot table which gathers all the census data. You can scroll to the right to view more census information. Don't forget to filter by cluster or store to refine your analysis.

![demographic snapshot.png](ypW5IxUVFkar)