If you want to directly test the Solution, you can see how by reading the [Getting Started](article:33) article.

# How to use the Project Setup?

Setting up the Solution requires some knowledge of data science, you may want to ask a data scientist or another technical colleague for assistance.

## Preparation Questions

Here are the questions you (as a business user) need to answer to help your tech colleague better prepare the data and set up the Solution:

- In which country are your stores located? If there are multiple countries, you need to choose just one country per project.

- For which time period do you want to analyze your store sales performance?

- Do you want to analyze your stores based on the population living around them? Or do you want to analyze your stores based on your category's sales performance? Or both?

### _If you want to analyze your stores based on the population living around them_
- The Solution examines the population living in your store trade areas, which are calculated within the Solution. How far do your trade areas extend from your stores? This can be defined by distance or travel time (by car, bicycle, or walking).

- The census data used for the Solution includes sub-population counts (e.g., the number of inhabitants aged 30 to 40 years).

1) Do you want to segment your stores based on **absolute sub-population counts**?

  _Example:_ In this scenario, you might get a `cluster A1` where trade areas have _a particularly high number of students_ compared to other areas, but the _proportion of students_ in one area might be 10%, while in another it might be 90%.
   Similarly, you might get a `cluster A2` where trade areas have _many employees_, but the _proportion of employees_ in one area might be 5%, while in another it might be 70%.
    
2) Or do you want to segment your stores based on **relative sub-population counts**?
 
 _Example:_ In this scenario, you might get a `cluster B1` where trade areas have _on average_ 40% men and 60% women, but one area might have only 500 men and 600 women, while another has 41,358 men and 59,904 women. 
  Similarly, you might get a `cluster B2` where trade areas have _on average_ 60% natives and 40% non-natives, but one area might have 620 natives and 390 non-natives, while another has 62,940 natives and 38,986 non-natives. 
  
- Do you want a specific number of clusters, or do you prefer to use the default numbers (it will be either 3, 4, or 5 clusters depending on the model's performance)?

### _If you want to analyze your stores based on your category's sales performance_
- Do you want to analyze only your category, or do you also want to compare its performance to other categories? If multiple categories, which ones?

- To cluster the stores based on sales per category, the transactional data used for the Solution is aggregated by product category and store.

1) Do you want to segment your stores based on **total category revenue** within a store?

  _Example:_ In this scenario, we only look at the **gross category revenue**. So you might get a `cluster a1` where the category MEN revenue in a store is on average _particularly high_ compared to other clusters, but the _category revenue share_ within one store can be 10% and within another store can be 90%. And you can get a `cluster a2` where the category MEN revenue in a store is on average _particularly low_ compared to other clusters, but the category revenue share within one store can be 85% and within another store can be 15%. 

    
2) Or do you want to segment your stores based on **category revenue share** within each store?
 
  _Example:_ In this scenario, we only look at the **category revenue share**. So you might get a `cluster b1` where the MEN category total store revenue **share** is on average at 80%, but the _gross category revenue_ within one store in `cluster b1` can be lower, while higher in another store from the same cluster. And you can get a `cluster b2` where the MEN category total store revenue **share** is on average at 15%, but the _gross category revenue_ within one store in `cluster b2` can be higher, while lower in another store from the same cluster. 


- Do you want a specific number of clusters, or do you prefer to use the default numbers (it will be either 3, 4, or 5 clusters depending on the model's performance)?

With answers to these questions, the data scientist should be able to set up the Solution.

## Setup

Here is an overview of the Project Setup and how to use it. For more details, refer to the [Project Setup](article:9) or [Getting Started](article:33) articles.

1. **Connection Settings**: Connect your data to a connection.
2. **Store Segmentation Strategies**: Choose the segmentation method you want to use.
3. **Data Loading and Store Preprocessing**: Load your datasets and run the store preprocessing.
4. **Transaction Preprocessing**: Define the transaction time period and granularity.
5. **Demographic Segmentation**: Define the store trade areas, census data aggregations, and some clustering model settings.
6. **Sales per Category Segmentation**: Define the targeted category(ies), transaction aggregations, and some clustering model settings.

# Dashboard

Once everything runs successfully, you can access the Dashboard pages using these buttons on the Project Setup page:
![Sales per Category dashboard button.png](SR8ANOstd2FU)
![Demographic dashboard button.png](Znb0552u3UMs)

Each dashboard has two slides: one for the segmentation results and another for the clustering model analysis.
The first slide is typically for a business user, while the second slide is for a technical user, such as a data scientist, to monitor model performance.

To help you navigate the dashboards, you can refer to the following articles:
- [Dashboard Sales per Category - Segmentation Results](article:11)
- [Dashboard Demographic - Slide Segmentation Results](article:30)
- [Dashboard Sales per Category - Clustering Model Analysis](article:31)
- [Dashboard Demographic - Slide Clustering Model Analysis](article:32)
