Here is how to go to the Project Setup page from the Flow:

![go-to-project-set-up.gif](4F73a6G7Q0VR)

The Project Setup gives the ability to configure the project to the user's needs with a visual interface.

# Connection Settings

![connections settings.png](o14N2yocRGC4)

The project is initially shipped with all datasets using the filesystem connection. The user can either leave it this way by not modifying the connection settings section or switch to their preferred connection. First, **select the connection** from the list of available connections. Then, press the `REFRESH` button to display the filesystem connection settings.

_If the main connection is either Redshift, Synapse, or BigQuery, you will be asked to select a filesystem connection because processes might need to be written in a filesystem connection._

_If the main connection is either S3, Azure, or Google Cloud Storage, you will be asked to choose an advanced file format._

Then, press `RECONFIGURE` to call the [reconfigure_flow_connections_settings](scenario:RECONFIGURE_FLOW_CONNECTIONS_SETTINGS) scenario that will **switch dataset connections** on the flow.

# Store Segmentation Strategies

![store segmentation strategies.png](oqNhEnFX7snl)

This section lets you choose **one or multiple store segmentation strategies**.

# Data Loading and Store Preprocessing

![data loading.png](gLL9moCgvaoF)

In this section, you can **load the datasets** required for the segmentation strategies selected above. The datasets need to be stored in a **data preparation project**, on the same connection as the one selected above. You need to enter the **project key** of the data preparation project, which you can find in its link:

![project key.png](qrvzR4gJFi9i)

If you need more information about how to prepare your data, go to the [Technical Requirements](article:16)  article and read the data model in the [Data Model](article:15) article.

Once the project key is entered in the text box and the datasets are selected, you can run the [build_inputs](scenario:BUILD_INPUTS) scenario through the `RUN NOW` button.

Once the inputs successfully run, you can refresh the page by pressing `REFRESH` to update the data displayed on the Project Setup page.

# Transaction Preprocessing

![transaction preprocessing.png](Mwb0a7KwvFG7)

The Store Segmentation Solution focuses on a certain **time period** since it uses transactional data. 
The first `RUN` button executes a scenario that will **display the first and last transaction dates available** in the loaded dataset ([get_first_and_last_transaction_dates](scenario:GET_FIRST_AND_LAST_TRANSACTION_DATES)).
To display the first and last transaction dates, click on the `REFRESH` button.

Then, you can define the **time granularity** that will be used to visualize the transaction data in the dashboards. You can choose between days, weeks, months, or quarters.

Finally, defining the time frame is done by selecting its **last date**, either by taking the last one available in your data or by explicitly choosing it. Then, you can select a **backward window** in months.
You can click on the `RUN NOW` button to preprocess the transactional data through the [build_transactions_preprocessing](scenario:BUILD_TRANSACTIONS_PREPROCESSING) scenario.

# Demographic Segmentation
## Store Preprocessing

If you have selected the demographic segmentation, you can first set up the geojoin recipe for joining the census and store data.

To join the census and store data, we create a trade area around each store. This trade area can be created based on either distance (a circular area around the store) or time travel with a certain transportation mode.

First, select the **trade area computation method**: either distance or time travel.
If it's **distance**, define the distance from the store (it must be an integer) and the distance unit: either Kilometers or Miles.

![geojoin distance.png](Api2ap0WnPsL)

If it's **time travel**, define the time from the stores in minutes and the transportation mode: either car, bicycle, or pedestrian.

![geojoin time travel.png](IUzzG5s1kk9q)

## Demographic Feature Engineering

![demographic feature engineering.png](rXM2N1QlHawe)

After defining the trade area, you can optionally define how the census data and store data will be joined. The default setting is "Join census areas if they are contained in the trade area". 

Regarding the census data feature engineering, you can decide whether to **sum the sub-population counts** or **calculate a percentage of the sub-population** over the total population in the trade area. 

To get more details about feature engineering (geojoin, census data aggregations...), see this [Flow Zone demography_feature_engineering](article:27) article.

## Demographic Clustering and Results

Finally, you can choose the number of clusters you would like to test or have, or leave the default numbers. If you choose several numbers of clusters to train models on, then the model having the best performance will be deployed.

You can also choose to define advanced feature rescaling settings: either Min-max rescaling or standard rescaling. The default rescaling method is min-max.

![demographic-clustering-settings.png](CGW7VwnwCZmt)

If the demographic clustering model has already been trained, you can choose to either retrain it or not.

![demographic-retrain.png](xLQrCRzM9pZj)

At this point, you can click on `RUN NOW` to execute the whole demographic branch through the [compute_demographic_segmentation_branch](scenario:COMPUTE_DEMOGRAPHIC_SEGMENTATION_BRANCH) scenario and then view the results on the demographic dashboards.

![demographic run and results.png](CcwEa2y7HTG8)

# Sales per Category Segmentation
## Sales per Category Feature Engineering

![sales per category segmentation.png](WFakt2NYWg3p)

If you have selected the sales per category segmentation strategy, you need to define some feature engineering settings, as well as clustering settings.

As we aggregate the transactional data for each store, we either sum the total sales per category or calculate the category share in each store.

You can also choose which category(ies) you want to analyze. The categories suggested are from the `target_category` column in the [products](dataset:products) dataset.

## Sales per Category Clustering and Results

Finally, you can choose the number of clusters you would like to test or have, or leave the default numbers. If you choose several numbers of clusters to train models on, then the model having the best performance will be deployed.

You can also choose to define advanced feature rescaling settings: either Min-max rescaling or standard rescaling. The default rescaling method is min-max.

![sales-per-category-clustering-settings.png](uDUy1V5klJ3u)

If the sales per category clustering model has already been trained, you can choose to either retrain it or not.

![sales per category retrain.png](UJJbiK6eX4yG)

At this point, you can click on `RUN NOW` to execute the whole sales per category branch through the [compute_sales_per_category_segmentation_branch](scenario:COMPUTE_SALES_PER_CATEGORY_SEGMENTATION_BRANCH) scenario and then view the results on the sales per category dashboards.

![sales per category run and results.png](uNld0zmNLYsN)
