# Scenario — Initial setup

This scenario applies the **project-level configuration** selected in Project Setup: it switches dataset connections, adapts recipe execution engines, configures the GenAI/LLM settings for the agent and tools, and then builds the core datasets required by the solution.

## What this scenario does

### 1) Change connection
Outcome: the Flow is aligned with the target SQL connection and recipes are set to run on the most appropriate available engine.

### 2) Set GenAI models
Outcome: the agent and its tools are consistent with the models and connections selected in Project Setup.

### 3) Build core datasets
Finally, the scenario triggers a recursive build of the main outputs used downstream:

- `supplier_orders_prepared_joined`
- `open_orders_for_prediction_prepared`

This ensures the project is in a ready-to-use state for dashboards, agent interactions, and delay scoring.

# Scenario — Data connection

This scenario wires the solution to your own data by **sharing the selected datasets into the solution project**, updating the Flow to use them, and then **building the pipeline outputs** required by the dashboards and the agent.

## What this scenario does

### 1) Share and connect selected datasets

- Shares the selected datasets from the source project into the current solution project
- Moves the shared datasets into the default flow zone
- Updates recipe inputs so the Flow uses user's selected datasets
It also merges any `local` variables into `standard` variables so the configuration is stored consistently at the project level.

### 2) Build flow
The scenario then runs a recursive build to produce the key output dataset:
- `open_orders_for_prediction_scored`


