# Annual Reports Embedding & Agents

This zone prepares unstructured supplier documentation (annual reports) for retrieval and wires the core assets into an agent experience. It enables the assistant to combine:
- **qualitative** insights (annual reports),
- **quantitative** insights (orders history),
- and **predictive** insights (delay-risk model).

## Inputs

- `annual_reports` (folder / source containing supplier annual reports)
- `supplier_orders_prepared_joined` (structured dataset for analytics)
- `Predict IS_DELAY` (model object, created in *Delay forecasting*)

## Key steps in this zone

### 1) Embed annual reports (`annual_reports_embedded`)
- Annual reports are processed and embedded to support semantic search and RAG-style answers.
- This is the foundation for questions like supplier strategy, restructuring, capacity changes, ESG commitments, and narrative explanations.

### 2) Connect tools to the agent (“Supply chain risk”)
The agent is configured to leverage multiple tool-backed sources, typically including:
- Retrieval from `annual_reports_embedded` (unstructured context)
- Querying `supplier_orders_prepared_joined` (structured KPIs and breakdowns)
- Scoring via `Predict IS_DELAY` (risk estimation for open orders / scenarios)
