# Delay forecasting

This zone trains (or refreshes) the **delay-risk model** and produces scored outputs for **open orders**, enabling:
- risk-based prioritization of undelivered orders,
- and what-if simulations (through the model tool in Agent Hub).

## Inputs

- `supplier_orders_prepared_joined` (historical orders, used to train/update the model)
- `open_orders_for_prediction` (open orders to be scored)

## Key steps in this zone

### 1) Train the delay-risk model (`Predict IS_DELAY`)
The model is trained from historical orders (`supplier_orders_prepared_joined`) to learn patterns correlated with delays.

### 2) Prepare open orders for scoring (`open_orders_for_prediction_prepared`)

### 3) Score open orders (`open_orders_for_prediction_scored`)
A scoring recipe applies the trained model to open orders, producing a predicted risk (probability/score)
