# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
sagemaker_churn = dataiku.Dataset("sagemaker_churn")
churn = sagemaker_churn.get_dataframe()


churn = churn.drop("Phone", axis=1)
churn["Area Code"] = churn["Area Code"].astype(object)
churn = churn.drop(["Day Charge", "Eve Charge", "Night Charge", "Intl Charge"], axis=1)
model_data = pd.get_dummies(churn)
model_data = pd.concat(
    [model_data["Churn?_True."], model_data.drop(["Churn?_False.", "Churn?_True."], axis=1)], axis=1
)

# Write recipe outputs
sagemaker_churn_prepared = dataiku.Dataset("sagemaker_churn_prepared")
sagemaker_churn_prepared.write_with_schema(model_data)
