### Baseline Model

The baseline model is trained without adjusting any variables or removing proxy variables. The overall model performance and fairness report is displayed on the [Project Dashboard](dashboard:zVQ6qzX). The fairness report indicates that the baseline model is skewed against older populations, specifically for the equality of opportunity metric. In this case the model has a far lower true positive rate for customers over the age of 55, meaning that it is missing a number of cases where a customer will churn in a way that is disproportionate to younger customers. 

### Model without Proxies

One way to reduce the model bias on the age variable is to make a model that removes both age and proxies for age. Based on the previous analysis, the Children in HH and Occupation variables are proxies for age, especially among older populations that tend to be retired and not have children at home. In the visual analysis for [baseline models](analysis:9cmsexlN) the session 'No Proxies' shows that while the model fairness improves, the overall model quality goes down. This tradeoff is not viable for a production model, so the final model will include the proxy variables. 

### Improved Model

To improve the overall reliability and fairness of the model, two main steps are taken. First, custom metrics to test for the equality of opportunity among age groups and location are incorporated in the the evalution. The equality of opportunity metics is used in order to minimize the error of missing true churns, especially for those clients with sensitive attributes. The second step to improve the model is to add assertions on how the model should perform. Given that at least 30 percent of clients over the age of 55 do churn in the historic data, the assertion checks that this baseline is met by any model. This gives us another check on the overall reliability of the model during deployment and retraining. 

In addition to these steps, the Credit Rating feature was removed from the final model. A full report of model performance on metrics and assertions, as well as individual explainations, is available on the last tab of the [Project Dashboard](dashboard:zVQ6qzX).