In this project you'll learn how to combine several models to build a churn prevention pipeline: segment customers, create insights to understand churn, and build a model to score new customers.

The data is from a major telecom operator. Just like pretty much any company in the world, they're concerned with keeping our customers happy, so they won't leave. In other words, they're looking at ways to reduce churn. To do this, they set up a task force of data analysts and people from business  teams who came up with several business goals to reduce churn.


<a name="GOAL">
# Business goal
</a>

- Get to know customers better, by accessing the data about their plans and usage, and getting in touch with interesting profiles
- Target clients with more effective advertising based on their usage profiles
- Retrieve customers with very high likeliness of churn so we could get in touch and offer them special deals before they even thought of leaving

<a name="HOW">
#How do we do this ?
</a>

We'll be working on historic data from users on their phone usage, as well as various features from very large log files. The clients who have churned are indicated in the dataset.

We have another dataset with the same features built on current clients. That will be used to deploy the model and predict who is likely to churn.

Instead of just answering the yes no question: "will they churn," we've decided to build two models instead of one:

1. A <strong>first model that segments customers</strong> into relevant groups (by using clustering algorithms), for targeting.
2. A <strong>second model that uses these segments (clusters) to predict the churn likeliness</strong> of each unlabelled customer (by using classification algorithms), so that business units can then check scores on a daily basis and target these customers.

<a name="VISIT">
#Explore this sample project
</a>

1. Look at the visual insights built to monitor churn and understand our customers behavior. We updated these as we went along by adding graph steps to our preparation scripts.<br/>
what could be a predictive business intelligence.<br/>
<p class="text-center">
<a href="/projects/DKU_CHURN/dashboards/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Dashboards</a><br/><br/>
</p>

2. Check out the few steps of data preparation and machine learning that are needed for this advanced analytics operation. You'll notice cleaning recipes (in yellow), and the 2 models in green.<br/>
<p class="text-center">
<a href="/projects/DKU_CHURN/flow/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Flow</a><br/><br/>
</p>

3. Look at the data preparation script to clean the customer data and create new features
<p class="text-center">
<a href="/projects/DKU_CHURN/recipes/compute_customers_prepared/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Visual Preparation</a><br/><br/>
</p>

4. Read here how we created the first model to segment our customers, and then deployed it on current customers' data as well as historical data.<br/>

<p class="text-center">
<a href="/projects/DKU_CHURN/savedmodels/UYFld51u/c/S-DKU_CHURN-UYFld51u-1486483327941/#summary"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Clustering model</a><br/><br/>
</p> 

5. Have a look at how we then worked on our second algorithm, to predict churn behaviour.<br/>

<p class="text-center">
<a href="/projects/DKU_CHURN/savedmodels/5HExUjQ1/p/S-DKU_CHURN-5HExUjQ1-1511270705375/#summary" class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Churn model</a><br/>
</p>

<a name="MORE">
