/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.BlackHoleFS;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ProtectedFiles;
import com.dataiku.dip.transactions.fs.ReadWriteFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.JournalizedFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.imfs.InMemoryCache;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;

public class InMemoryFS
extends ReadWriteFSBase
implements JournalizedFS {
    private final InMemoryDiff diff;
    private ProtectedFiles protectedFiles = ProtectedFiles.TRANSACTION_PROTECTED_FILES;

    public InMemoryFS(ReadOnlyFS base, boolean cached, FileContentFactory fileContentFactory) {
        super(fileContentFactory);
        this.diff = new InMemoryDiff(cached ? new InMemoryCache(base) : base, fileContentFactory);
    }

    public InMemoryFS(ReadOnlyFS base, boolean cached) {
        this(base, cached, FileContentFactory.DEFAULT);
    }

    public InMemoryFS() {
        this(new BlackHoleFS(), false);
    }

    @Override
    public synchronized void setProtectedFiles(ProtectedFiles pf) {
        this.protectedFiles = pf;
    }

    @Override
    public synchronized Journal buildJournal() throws IOException {
        return this.diff.buildJournal();
    }

    @Override
    public synchronized boolean deleteFile(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        return this.diff.deleteFile(file);
    }

    @Override
    public synchronized boolean deleteDirectory(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        return this.diff.deleteDirectory(directory);
    }

    @Override
    public synchronized boolean makeDirectory(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        return this.diff.makeDirectory(directory);
    }

    @Override
    public synchronized void writeContentUnsafeNoMkdir(RelFile file, FileContent content) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        this.diff.writeContentUnsafeNoMkdir(file, content);
    }

    @Override
    public synchronized List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        List<RelFile> files = this.diff.listFilesUnordered(directory);
        files.removeIf(file -> this.protectedFiles.isProtected((RelFile)file));
        return files;
    }

    @Override
    public List<RelFile> listFiles(RelFile directory) throws IOException {
        this.protectedFiles.assertNotProtected(directory);
        List<RelFile> files = this.diff.listFiles(directory);
        files.removeIf(file -> this.protectedFiles.isProtected((RelFile)file));
        return files;
    }

    @Override
    public synchronized void moveFile(RelFile src, RelFile dst) throws IOException {
        this.protectedFiles.assertNotProtected(src);
        this.protectedFiles.assertNotProtected(dst);
        this.diff.moveFile(src, dst);
    }

    @Override
    public synchronized FileContent readContentUnsafe(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        return this.diff.readContentUnsafe(file);
    }

    @Override
    public synchronized RelFileAttribute getAttributes(RelFile file) throws IOException {
        this.protectedFiles.assertNotProtected(file);
        return this.diff.getAttributes(file);
    }

    @VisibleForTesting
    public synchronized void checkInvariants() {
        this.diff.checkInvariants();
    }
}

