/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils.copy;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.copy.CopyMethod;
import java.io.IOException;
import javax.annotation.Nullable;

public class FileContentRefCopyMethod
implements CopyMethod {
    private final FSUtils.CopyStats stats = new FSUtils.CopyStats();

    @Override
    public void copyFile(ReadOnlyFS srcFS, RelFile srcFile, @Nullable RelFileAttribute srcAttr, ReadWriteFS dstFS, RelFile dstFile, @Nullable RelFileAttribute dstAttr) throws IOException {
        try {
            FileContent content = srcFS.readContentUnsafe(srcFile);
            dstFS.writeContentUnsafeNoMkdir(dstFile, content);
            ++this.stats.nbFilesCopied;
        }
        catch (Exception e) {
            throw new IOException("Error while copying \"" + String.valueOf(srcFile) + "\" to \"" + String.valueOf(dstFile) + "\" (" + e.getMessage() + ")", e);
        }
    }

    @Override
    public FSUtils.CopyStats getStats() {
        return this.stats;
    }

    @Override
    public void close() {
    }
}

