/*
 * Decompiled with CFR 0.152.
 */
package com.lastpass.saml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import com.lastpass.saml.AttributeSet;
import com.lastpass.saml.IdPConfig;
import com.lastpass.saml.SAMLException;
import com.lastpass.saml.SPConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLClient {
    private SPConfig spConfig;
    private IdPConfig idpConfig;
    private List<BasicCredential> credentials;
    private BasicParserPool parsers;
    @VisibleForTesting
    public boolean bypassSignatureCheck = false;
    private static final int slack = (int)TimeUnit.MINUTES.toSeconds(5L);

    public SAMLClient(SPConfig spConfig, IdPConfig idpConfig) throws SAMLException {
        this.spConfig = spConfig;
        this.idpConfig = idpConfig;
        this.credentials = new ArrayList<BasicCredential>();
        for (Certificate cert : idpConfig.getCerts()) {
            BasicCredential cred = new BasicCredential(cert.getPublicKey());
            cred.setEntityId(idpConfig.getEntityId());
            this.credentials.add(cred);
        }
        this.parsers = new BasicParserPool();
        this.parsers.setNamespaceAware(true);
        try {
            this.parsers.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public IdPConfig getIdPConfig() {
        return this.idpConfig;
    }

    public SPConfig getSPConfig() {
        return this.spConfig;
    }

    private Response parseResponse(String authnResponse) throws SAMLException {
        try {
            Document doc = this.parsers.getBuilder().parse(new InputSource(new StringReader(authnResponse)));
            Element root = doc.getDocumentElement();
            return (Response)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(root).unmarshall(root);
        }
        catch (SAXException e) {
            throw new SAMLException(e);
        }
        catch (IOException e) {
            throw new SAMLException(e);
        }
        catch (XMLParserException e) {
            throw new RuntimeException(e);
        }
        catch (UnmarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    private Assertion decrypt(EncryptedAssertion encrypted) throws DecryptionException {
        if (this.spConfig.getPrivateKey() == null) {
            throw new DecryptionException("Encrypted assertion found but no SP key available");
        }
        BasicCredential cred = new BasicCredential(this.spConfig.getCertificate().getPublicKey(), this.spConfig.getPrivateKey());
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver((Credential)cred);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
        decrypter.setRootInNewDocument(true);
        return decrypter.decrypt(encrypted);
    }

    private List<Assertion> getAssertions(Response response) throws DecryptionException {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        assertions.addAll(response.getAssertions());
        for (EncryptedAssertion e : response.getEncryptedAssertions()) {
            assertions.add(this.decrypt(e));
        }
        return assertions;
    }

    private void validate(Signature signature) throws SAMLException {
        if (this.bypassSignatureCheck) {
            return;
        }
        SAMLException samlException = null;
        for (BasicCredential credential : this.credentials) {
            try {
                SignatureValidator.validate((Signature)signature, (Credential)credential);
                return;
            }
            catch (SignatureException e) {
                samlException = new SAMLException("Invalid signature", e);
            }
        }
        throw samlException;
    }

    private void validate(Response response) throws SAMLException {
        Boolean responseSigned = response.isSigned();
        if (responseSigned.booleanValue()) {
            this.validate(response.getSignature());
        }
        if (response.getStatus() == null || response.getStatus().getStatusCode() == null || !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            throw new SAMLException("Response has an unsuccessful status code");
        }
        if (responseSigned.booleanValue() && response.getDestination() == null) {
            throw new SAMLException("Response message is signed and does not include a Destination attribute");
        }
        if (response.getDestination() != null && !this.spConfig.getAcs().equals(response.getDestination())) {
            throw new SAMLException("Response is destined for a different endpoint (response destination='" + response.getDestination() + "' SP ACS='" + this.spConfig.getAcs() + "'");
        }
        Instant now = Instant.now();
        Instant issueInstant = response.getIssueInstant();
        if (issueInstant != null) {
            if (issueInstant.isBefore(now.minusSeconds(slack))) {
                throw new SAMLException("Response IssueInstant is in the past");
            }
            if (issueInstant.isAfter(now.plusSeconds(slack))) {
                throw new SAMLException("Response IssueInstant is in the future");
            }
        }
        List<Assertion> assertions = null;
        try {
            assertions = this.getAssertions(response);
        }
        catch (DecryptionException e) {
            throw new SAMLException(e);
        }
        for (Assertion assertion : assertions) {
            if (assertion.isSigned()) {
                this.validate(assertion.getSignature());
            } else if (!responseSigned.booleanValue()) {
                throw new SAMLException("Assertion must be signed");
            }
            if (assertion.getAuthnStatements().isEmpty()) {
                throw new SAMLException("Assertion should contain an AuthnStatement");
            }
            for (AuthnStatement as : assertion.getAuthnStatements()) {
                Instant exp;
                Instant sessionTime = as.getSessionNotOnOrAfter();
                if (sessionTime == null || (exp = sessionTime.plusSeconds(slack)) == null || !now.equals(exp) && !now.isAfter(exp)) continue;
                throw new SAMLException("AuthnStatement has expired");
            }
            if (assertion.getConditions() == null) {
                throw new SAMLException("Assertion should contain conditions");
            }
            Instant instant = assertion.getIssueInstant();
            if (instant != null) {
                if (instant.isBefore(now.minusSeconds(slack))) {
                    throw new SAMLException("Response IssueInstant is in the past");
                }
                if (instant.isAfter(now.plusSeconds(slack))) {
                    throw new SAMLException("Response IssueInstant is in the future");
                }
            }
            Conditions conditions = assertion.getConditions();
            Instant notBefore = conditions.getNotBefore();
            Instant notOnOrAfter = conditions.getNotOnOrAfter();
            if (notBefore == null || notOnOrAfter == null) {
                throw new SAMLException("Assertion conditions must have limits");
            }
            notBefore = notBefore.minusSeconds(slack);
            notOnOrAfter = notOnOrAfter.plusSeconds(slack);
            if (now.isBefore(notBefore)) {
                throw new SAMLException("Assertion conditions is in the future");
            }
            if (now.equals(notOnOrAfter) || now.isAfter(notOnOrAfter)) {
                throw new SAMLException("Assertion conditions is in the past");
            }
            Subject subject = assertion.getSubject();
            if (subject != null && !subject.getSubjectConfirmations().isEmpty()) {
                boolean foundRecipient = false;
                for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                    Instant chkdate;
                    if (sc.getSubjectConfirmationData() == null) continue;
                    SubjectConfirmationData scd = sc.getSubjectConfirmationData();
                    if (scd.getNotOnOrAfter() != null && (now.equals(chkdate = scd.getNotOnOrAfter().plusSeconds(slack)) || now.isAfter(chkdate))) {
                        throw new SAMLException("SubjectConfirmationData is in the past");
                    }
                    if (!this.spConfig.getAcs().equals(scd.getRecipient())) continue;
                    foundRecipient = true;
                }
                if (!foundRecipient) {
                    throw new SAMLException("No SubjectConfirmationData found for ACS");
                }
            }
            if (conditions.getAudienceRestrictions().isEmpty()) {
                throw new SAMLException("Assertion conditions must have audience restrictions");
            }
            if (conditions.getAudienceRestrictions().size() > 1) {
                throw new SAMLException("Assertion contains multiple audience restrictions");
            }
            AudienceRestriction ar = (AudienceRestriction)conditions.getAudienceRestrictions().get(0);
            boolean foundSP = false;
            for (Audience a : ar.getAudiences()) {
                if (!this.spConfig.getEntityId().equals(a.getURI())) continue;
                foundSP = true;
            }
            if (foundSP) continue;
            throw new SAMLException("Assertion audience does not include issuer (i.e. SP EntityId: '" + this.spConfig.getEntityId() + "')");
        }
    }

    private String createAuthnRequest(String requestId) throws SAMLException {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        request.setAssertionConsumerServiceURL(this.spConfig.getAcs().toString());
        request.setDestination(this.idpConfig.getLoginUrl().toString());
        request.setIssueInstant(Instant.now());
        request.setID(requestId);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(this.spConfig.getEntityId());
        request.setIssuer(issuer);
        try {
            Element elem = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)request).marshall((XMLObject)request);
            Document document = elem.getOwnerDocument();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer serializer = domImplLS.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            return serializer.writeToString(elem);
        }
        catch (MarshallingException e) {
            throw new SAMLException(e);
        }
    }

    private byte[] deflate(byte[] input) throws IOException {
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(input);
        deflater.finish();
        byte[] tmp = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (!deflater.finished()) {
            int count = deflater.deflate(tmp);
            bos.write(tmp, 0, count);
        }
        bos.close();
        deflater.end();
        return bos.toByteArray();
    }

    public String generateAuthnRequest(String requestId) throws SAMLException {
        String request = this.createAuthnRequest(requestId);
        try {
            byte[] compressed = this.deflate(request.getBytes("UTF-8"));
            return BaseEncoding.base64().encode(compressed);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLException("Apparently your platform lacks UTF-8.  That's too bad.", e);
        }
        catch (IOException e) {
            throw new SAMLException("Unable to compress the AuthnRequest", e);
        }
    }

    public AttributeSet validateResponse(String authnResponse) throws SAMLException {
        byte[] decoded = Base64.decodeBase64((String)authnResponse);
        try {
            authnResponse = new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SAMLException("UTF-8 is missing, oh well.", e);
        }
        Response response = this.parseResponse(authnResponse);
        this.validate(response);
        List<Assertion> assertions = null;
        try {
            assertions = this.getAssertions(response);
        }
        catch (DecryptionException e) {
            throw new SAMLException(e);
        }
        if (assertions.size() != 1) {
            throw new SAMLException("Response should have a single assertion.");
        }
        Assertion assertion = assertions.get(0);
        Subject subject = assertion.getSubject();
        if (subject == null) {
            throw new SAMLException("No subject contained in the assertion.");
        }
        if (subject.getNameID() == null) {
            throw new SAMLException("No NameID found in the subject.");
        }
        String nameId = subject.getNameID().getValue();
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        for (AttributeStatement atbs : assertion.getAttributeStatements()) {
            for (Attribute atb : atbs.getAttributes()) {
                String name = atb.getName();
                ArrayList<String> values = new ArrayList<String>();
                for (XMLObject obj : atb.getAttributeValues()) {
                    values.add(obj.getDOM().getTextContent());
                }
                attributes.put(name, values);
            }
        }
        return new AttributeSet(nameId, attributes);
    }
}

