/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class ApplicationConfigurator
extends DKUApp {
    protected static Logger logger = Logger.getLogger(ApplicationConfigurator.class);

    public static void autoconfigure() {
        ApplicationConfigurator.ensureCorrectJavaVersionForDev();
        String dipHome = System.getenv("DIP_HOME");
        String installDir = System.getenv("DKUINSTALLDIR");
        if (dipHome != null && installDir != null) {
            ApplicationConfigurator.setBaseFolder((String)dipHome, (String)installDir);
            ProxyUtils.registerProxyAuthenticator(ApplicationConfigurator::getProxySettings);
        }
    }

    public static boolean isSingleUser() {
        return ApplicationConfigurator.getParams().getBoolParam("singleUser", false);
    }

    public static GeneralSettingsDAO.GeneralSettings getGeneralSettings() {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        block9: {
            RelFile f = RelFile.global((String)"general-settings.json");
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            assert (transactionService != null);
            Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
            try {
                generalSettings = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
                if (t == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            t.close();
        }
        return generalSettings;
    }

    public static GeneralSettingsDAO.GeneralSettings getGeneralSettingsUnsafeAutoTXN() {
        try {
            GeneralSettingsDAO bean = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
            SpringUtils.getInstance().autowire((Object)bean);
            return bean.getUnsafeAutoTXN();
        }
        catch (IOException e) {
            throw new Error("failed to get general settings", e);
        }
    }

    @Nonnull
    public static ProxySettings getProxySettings() {
        PasswordEncryptionService cryptoService = SpringUtils.getInstance().hasBean(PasswordEncryptionService.class) ? (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class) : null;
        return ApplicationConfigurator.getProxySettings(cryptoService);
    }

    @Nonnull
    public static ProxySettings getProxySettings(PasswordEncryptionService cryptoService) {
        try {
            ProxySettings proxySettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().proxySettings.deepCopy();
            if (cryptoService != null) {
                proxySettings.decryptFields(cryptoService);
            }
            return proxySettings;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static DSSNodeType getNodeType() {
        return DSSNodeType.GOVERN;
    }

    public static enum DSSNodeType {
        GOVERN;

    }
}

