/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints;

import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.visitors.IBlueprintVersionIdVisitor;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BlueprintVersionId {
    public String blueprintId;
    public String versionId;

    public void accept(IBlueprintVersionIdVisitor blueprintVersionIdVisitor) {
        blueprintVersionIdVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueprintVersionId that = (BlueprintVersionId)o;
        return Objects.equals(this.blueprintId, that.blueprintId) && Objects.equals(this.versionId, that.versionId);
    }

    public int hashCode() {
        return Objects.hash(this.blueprintId, this.versionId);
    }

    public String toString() {
        return "{blueprintId: " + this.blueprintId + ", versionId: " + this.versionId + "}";
    }

    public static BlueprintVersionId build(String blueprintId, String versionId) {
        if (StringUtils.isBlank((CharSequence)blueprintId)) {
            throw new ValidationException("blueprintId is required");
        }
        if (StringUtils.isBlank((CharSequence)versionId)) {
            throw new ValidationException("versionId is required");
        }
        BlueprintVersionId blueprintVersionId = new BlueprintVersionId();
        blueprintVersionId.blueprintId = blueprintId;
        blueprintVersionId.versionId = versionId;
        return blueprintVersionId;
    }
}

