/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints.ui;

import com.dataiku.gh.core.models.blueprints.ui.UIStepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UIDefinition {
    public Map<String, View> views = new HashMap<String, View>();
    public Map<String, UIStepDefinition> uiStepDefinitions = new HashMap<String, UIStepDefinition>();
    public String artifactPageViewId;

    public void accept(IBlueprintVersionVisitor blueprintVersionVisitor) {
        this.views.forEach((id, view) -> view.accept(blueprintVersionVisitor, (String)id));
        this.uiStepDefinitions.forEach((id, step) -> step.accept(blueprintVersionVisitor, (String)id));
        blueprintVersionVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UIDefinition that = (UIDefinition)o;
        return Objects.equals(this.views, that.views) && Objects.equals(this.uiStepDefinitions, that.uiStepDefinitions) && Objects.equals(this.artifactPageViewId, that.artifactPageViewId);
    }

    public int hashCode() {
        return Objects.hash(this.views, this.uiStepDefinitions, this.artifactPageViewId);
    }

    public static UIDefinition build(Map<String, View> views, Map<String, UIStepDefinition> uiStepDefinitions, String artifactPageViewId) {
        UIDefinition uiDefinition = new UIDefinition();
        uiDefinition.views = views;
        uiDefinition.uiStepDefinitions = uiStepDefinitions;
        uiDefinition.artifactPageViewId = artifactPageViewId;
        return uiDefinition;
    }

    public boolean hasConditionalViews() {
        return this.views.values().stream().anyMatch(view -> view.viewComponent != null && view.viewComponent.hasConditionalView());
    }
}

