/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.system;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.system.ISystemProvidedBlueprintVersionsCacheService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemProvidedBlueprintVersionsCacheService
implements ISystemProvidedBlueprintVersionsCacheService {
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private final ConcurrentHashMap<BlueprintVersionId, EnrichedBlueprintVersion> dataikuEnrichedVersionsBlueprintVersionMap = new ConcurrentHashMap();
    @Autowired
    private IBlueprintsDataService blueprintsDataService;

    private synchronized void initBlueprintVersion(IBlueprintsDataService blueprintsDataService) throws IOException {
        if (!this.loaded.get()) {
            blueprintsDataService.listBlueprintVersions().stream().filter(uiBlueprintVersion -> SystemProvidedConstants.SYSTEM_BLUEPRINT_BY_ID.containsKey(uiBlueprintVersion.blueprint.id) && SystemProvidedConstants.SYSTEM_BLUEPRINT_BY_ID.get((Object)uiBlueprintVersion.blueprint.id).defaultBlueprintVersionIds.contains(uiBlueprintVersion.blueprintVersion.id)).forEach(uiBlueprintVersion -> this.dataikuEnrichedVersionsBlueprintVersionMap.put(uiBlueprintVersion.blueprintVersion.id, (EnrichedBlueprintVersion)uiBlueprintVersion));
            this.loaded.set(true);
        }
    }

    @Override
    public EnrichedBlueprintVersion getSystemEnrichedDefaultBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        EnrichedBlueprintVersion enrichedBlueprintVersion;
        assert (blueprintVersionId != null);
        if (!this.loaded.get()) {
            this.initBlueprintVersion(this.blueprintsDataService);
        }
        if ((enrichedBlueprintVersion = this.dataikuEnrichedVersionsBlueprintVersionMap.get(blueprintVersionId)) == null) {
            throw new RuntimeException("Default blueprint version for system blueprint not found: " + String.valueOf(blueprintVersionId));
        }
        return enrichedBlueprintVersion;
    }
}

