/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.services.validation.IUsersContainerValidationService;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.utils.FunctionUtils;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersContainerValidationService
implements IUsersContainerValidationService {
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;

    @Override
    public void validate(UsersContainersExtraction extraction) throws IOException {
        this.validate(extraction, UsersContainersValidationConfig.buildValidateAll());
    }

    @Override
    public UsersContainersExtraction validate(UsersContainersExtraction extraction, UsersContainersValidationConfig usersContainersValidationConfig) throws IOException {
        UsersContainersExtraction toDelete = new UsersContainersExtraction();
        try (Transaction t = this.transactionService.beginRead();){
            this.validateOrAddToDelete(extraction.logins, () -> this.usersDAO.listUsersUnsafe().stream().map(user -> user.login), usersContainersValidationConfig.forUsers, toDelete::addLogins, "User(s) not found: %s");
            this.validateOrAddToDelete(extraction.groupNames, () -> this.usersDAO.listGroupsUnsafe().stream().map(group -> group.name), usersContainersValidationConfig.forGroups, toDelete::addGroupsNames, "Group(s) not found: %s");
            this.validateOrAddToDelete(extraction.globalAPIKeyIds, () -> this.publicAPIKeysService.listGlobalAPIKeys().stream().map(apiKey -> apiKey.id), usersContainersValidationConfig.forApiKeys, toDelete::addGlobalApiKeys, "Global api key(s) not found: %s");
        }
        this.validateOrAddToDelete(extraction.roleIds, () -> this.roleDAO.list().stream().map(role -> role.id), usersContainersValidationConfig.forRoles, toDelete::addRoleIds, "Role(s) not found: %s");
        return toDelete;
    }

    private <T> void validateOrAddToDelete(Collection<T> collectionToCheck, FunctionUtils.SupplierWithIoException<Stream<T>> existingCollectionSupplier, UsersContainersValidationConfig.ValidationBehavior validationBehavior, Consumer<Collection<T>> addToDelete, String errMsgPattern) throws IOException {
        if (CollectionUtils.isEmpty(collectionToCheck)) {
            return;
        }
        Set existingCollection = existingCollectionSupplier.get().collect(Collectors.toSet());
        HashSet<T> notFoundsCollection = new HashSet<T>(collectionToCheck);
        notFoundsCollection.removeAll(existingCollection);
        switch (validationBehavior) {
            case ALL: {
                if (!CollectionUtils.isNotEmpty(notFoundsCollection)) break;
                throw new NotFoundException(String.format(errMsgPattern, notFoundsCollection));
            }
            case EXISTING: {
                addToDelete.accept(notFoundsCollection);
                break;
            }
            case NONE: {
                addToDelete.accept(collectionToCheck);
            }
        }
    }
}

