/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.audit.model.AuditTrailSettings;
import com.dataiku.dip.security.auth.AuthSyncSettings;
import com.dataiku.dip.security.auth.CustomAuthSettings;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.pam.PAMSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2py.annotations.PyModel;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralSettingsDAO {
    @Autowired
    private TransactionService transactionService;
    private static RelFile f = RelFile.global((String)"general-settings.json");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.generalSettings.dao");

    public GeneralSettings read() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (GeneralSettings)t.readObjectDefault(f, GeneralSettings.class);
    }

    public GeneralSettings getUnsafe() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(f)) {
            return (GeneralSettings)t.readObjectUnsafe(f, GeneralSettings.class);
        }
        return new GeneralSettings();
    }

    public GeneralSettings getUnsafeAutoTXN() throws IOException {
        if (this.transactionService == null) {
            logger.warn((Object)"dep injection mess : transactionService isn't ready");
            this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
            GeneralSettings generalSettings = this.getUnsafe();
            return generalSettings;
        }
    }

    public long getLastModified() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.getLastModified(f);
    }

    public void save(GeneralSettings gs) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(f, (Object)gs);
    }

    @PyModel
    @UIModel
    public static class GeneralSettings {
        public UsageDataReporting.UsageDataReportingMode udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
        public boolean errorsReportingEnabled = true;
        public ProxySettings proxySettings = new ProxySettings();
        public LdapSettings ldapSettings = new LdapSettings();
        public AuthSyncSettings authSyncSettings = new AuthSyncSettings();
        public PAMSettings pamSettings = new PAMSettings();
        public SSOSettings ssoSettings = new SSOSettings();
        public AzureADSettings azureADSettings = new AzureADSettings();
        public CustomAuthSettings customAuthSettings = new CustomAuthSettings();
        public boolean noLoginMode;
        public String noLoginImpersonate;
        public SecuritySettings security = new SecuritySettings();
        public String studioExternalUrl;
        public String studioMailAddress;
        public String studioForgotPasswordUrl;
        public String studioAdminContact;
        public String graphiteServerUrl;
        public String graphiteMetricPrefix;
        public int graphiteReportingDelay;
        public String nodeName;
        public CorsSettings corsSettings = new CorsSettings();
        public AuditTrailSettings auditTrailSettings = new AuditTrailSettings();
        public long uploadedFilesMaxSize = 0x3200000L;
        public List<IntegrationChannel> integrationChannels = new ArrayList<IntegrationChannel>();
        public String emailChannelId;
        public List<FallbackNodeRef> fallbackNodeRefs = new ArrayList<FallbackNodeRef>();
    }

    public static class FallbackNodeRef {
        public String nodeId;
        public String url;
    }

    public static enum PostLogoutBehavior {
        LOGGED_OUT_PAGE,
        CUSTOM_URL;

    }

    public static class SecuritySettings {
        public boolean hideVersionStringsWhenNotLogged;
        public boolean hideLogs;
        public boolean hideErrorStacks;
        public boolean hideLogTails;
        public boolean secureCookies;
        public boolean sameSiteNoneCookies;
        public int sessionsMaxTotalTimeMinutes;
        public int sessionsMaxIdleTimeMinutes;
        public boolean forceSingleSessionPerUser;
        public boolean restrictUsersAndGroupsVisibility;
        public boolean caseSensitiveLogins = true;
        public boolean ipBoundSessions;
        public PostLogoutBehavior postLogoutBehavior = PostLogoutBehavior.LOGGED_OUT_PAGE;
        public String postLogoutCustomURL;
        public boolean enableEmailAndDisplayNameModification = false;
        public boolean hashApiKeys = true;
        public int apiKeysLifetimeDays = 0;
    }

    public static class CorsSettings {
        public Set<String> accessControlAllowOriginRegExps = new HashSet<String>();
        public Set<String> accessControlExposeHeaders = new HashSet<String>();
        public Integer accessControlMaxAge;
        public Set<String> accessControlAllowMethods = new HashSet<String>();
        public Set<String> accessControlAllowHeaders = new HashSet<String>();
        public boolean accessControlAllowCredentials;
    }
}

