/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.utils;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.utils.DSEncryptionProperties;
import com.databricks.client.jdbc.utils.DSStringCache;
import com.databricks.client.jdbc.utils.DSStringEncryptedCache;
import com.databricks.client.jdbc.utils.DSStringFileCache;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class OAuthTokenCache {
    private static Boolean DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG = false;
    private static Boolean DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG = false;
    private static String TEMP_FILE_DIRECTORY_KEY = "java.io.tmpdir";
    private static char DELIMITER_CHAR = (char)32;
    private static String CACHE_FILE_NAME_SUFFIX = "OAuth2TokenCache";
    private static final String SYSTEM_CURRENT_USER = "user.name";
    private DSStringEncryptedCache m_cache;

    public OAuthTokenCache(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, String string) throws ErrorException {
        String string2 = "Databricks" + hiveJDBCSettings.m_platformVersionUtils.getDriverNamePrefix();
        Pattern pattern = Pattern.compile("[\\\\\\\\/:*?\\\"<>|.]");
        Path path = Paths.get(System.getProperty(TEMP_FILE_DIRECTORY_KEY), new String[0]);
        String string3 = string2 + "_" + CACHE_FILE_NAME_SUFFIX + "_" + pattern.matcher(System.getProperty(SYSTEM_CURRENT_USER)).replaceAll("");
        String string4 = path.resolve(Paths.get(string3, new String[0])).toString();
        DSEncryptionProperties dSEncryptionProperties = new DSEncryptionProperties(hiveJDBCSettings.m_tokenCachePassphrase, string, iLogger, false);
        this.m_cache = new DSStringEncryptedCache(iLogger, new DSStringFileCache(iLogger, string4, DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG, DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG, DELIMITER_CHAR), DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG, DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG, dSEncryptionProperties);
    }

    public DSStringCache getTokenCache() {
        return this.m_cache;
    }
}

