/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class FastPrimitiveArrayAdapters {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = .Gson.Types.getArrayComponentType((Type)type);
            Class rawComponentType = .Gson.Types.getRawType((Type)componentType);
            if (rawComponentType == Double.TYPE) {
                return new DoubleArrayAdapter(FastPrimitiveArrayAdapters.detectSerializeSpecialFloatingPointValues(gson));
            }
            if (rawComponentType == Float.TYPE) {
                return new FloatArrayAdapter(FastPrimitiveArrayAdapters.detectSerializeSpecialFloatingPointValues(gson));
            }
            if (rawComponentType == Integer.TYPE) {
                return new IntArrayAdapter();
            }
            if (rawComponentType == Long.TYPE) {
                return new LongArrayAdapter();
            }
            if (rawComponentType == Boolean.TYPE) {
                return new BooleanArrayAdapter();
            }
            return null;
        }
    };
    private static final int INITIAL_CAPACITY = 10;

    private static void checkValidFloatingPoint(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException(value + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static boolean detectSerializeSpecialFloatingPointValues(Gson gson) {
        try {
            gson.toJson((Object)Double.POSITIVE_INFINITY);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static class LongArrayAdapter
    extends TypeAdapter<long[]> {
        private static final long[] EMPTY = new long[0];

        private LongArrayAdapter() {
        }

        public long[] read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            if (!in.hasNext()) {
                in.endArray();
                return EMPTY;
            }
            int index = 0;
            long[] array = new long[10];
            do {
                int n;
                if (index >= (n = array.length)) {
                    array = Arrays.copyOf(array, n + (n >> 2) + 1);
                }
                array[index] = in.nextLong();
                ++index;
            } while (in.hasNext());
            in.endArray();
            return Arrays.copyOf(array, index);
        }

        public void write(JsonWriter out, long[] array) throws IOException {
            if (array == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (long l : array) {
                out.value(l);
            }
            out.endArray();
        }
    }

    private static class BooleanArrayAdapter
    extends TypeAdapter<boolean[]> {
        private static final boolean[] EMPTY = new boolean[0];

        private BooleanArrayAdapter() {
        }

        public boolean[] read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            if (!in.hasNext()) {
                in.endArray();
                return EMPTY;
            }
            int index = 0;
            boolean[] array = new boolean[10];
            do {
                int n;
                if (index >= (n = array.length)) {
                    array = Arrays.copyOf(array, n + (n >> 2) + 1);
                }
                array[index] = in.nextBoolean();
                ++index;
            } while (in.hasNext());
            in.endArray();
            return Arrays.copyOf(array, index);
        }

        public void write(JsonWriter out, boolean[] array) throws IOException {
            if (array == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (boolean b : array) {
                out.value(b);
            }
            out.endArray();
        }
    }

    private static class IntArrayAdapter
    extends TypeAdapter<int[]> {
        private static final int[] EMPTY = new int[0];

        private IntArrayAdapter() {
        }

        public int[] read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            if (!in.hasNext()) {
                in.endArray();
                return EMPTY;
            }
            int index = 0;
            int[] array = new int[10];
            do {
                int n;
                if (index >= (n = array.length)) {
                    array = Arrays.copyOf(array, n + (n >> 2) + 1);
                }
                array[index] = in.nextInt();
                ++index;
            } while (in.hasNext());
            in.endArray();
            return Arrays.copyOf(array, index);
        }

        public void write(JsonWriter out, int[] array) throws IOException {
            if (array == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (int j : array) {
                out.value((long)j);
            }
            out.endArray();
        }
    }

    private static class FloatArrayAdapter
    extends TypeAdapter<float[]> {
        private static final float[] EMPTY = new float[0];
        private final boolean serializeSpecialFloatingPointValues;

        public FloatArrayAdapter(boolean serializeSpecialFloatingPointValues) {
            this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        }

        public float[] read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            if (!in.hasNext()) {
                in.endArray();
                return EMPTY;
            }
            int index = 0;
            float[] array = new float[10];
            do {
                int n;
                if (index >= (n = array.length)) {
                    array = Arrays.copyOf(array, n + (n >> 2) + 1);
                }
                array[index] = (float)in.nextDouble();
                ++index;
            } while (in.hasNext());
            in.endArray();
            return Arrays.copyOf(array, index);
        }

        public void write(JsonWriter out, float[] array) throws IOException {
            if (array == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (float v : array) {
                if (!this.serializeSpecialFloatingPointValues) {
                    FastPrimitiveArrayAdapters.checkValidFloatingPoint(v);
                }
                out.value((Number)Float.valueOf(v));
            }
            out.endArray();
        }
    }

    private static class DoubleArrayAdapter
    extends TypeAdapter<double[]> {
        private static final double[] EMPTY = new double[0];
        private final boolean serializeSpecialFloatingPointValues;

        public DoubleArrayAdapter(boolean serializeSpecialFloatingPointValues) {
            this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        }

        public double[] read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            if (!in.hasNext()) {
                in.endArray();
                return EMPTY;
            }
            int index = 0;
            double[] array = new double[10];
            do {
                int n;
                if (index >= (n = array.length)) {
                    array = Arrays.copyOf(array, n + (n >> 2) + 1);
                }
                array[index] = in.nextDouble();
                ++index;
            } while (in.hasNext());
            in.endArray();
            return Arrays.copyOf(array, index);
        }

        public void write(JsonWriter out, double[] array) throws IOException {
            if (array == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (double v : array) {
                if (!this.serializeSpecialFloatingPointValues) {
                    FastPrimitiveArrayAdapters.checkValidFloatingPoint(v);
                }
                out.value((Number)v);
            }
            out.endArray();
        }
    }
}

