/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal;

import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.trino.jdbc.$internal.okhttp3.Connection;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.annotation.Nullable;

public enum OkHttpAttributesGetter implements HttpClientAttributesGetter<Interceptor.Chain, Response>
{
    INSTANCE;


    public String getHttpRequestMethod(Interceptor.Chain chain) {
        return chain.request().method();
    }

    public String getUrlFull(Interceptor.Chain chain) {
        return chain.request().url().toString();
    }

    public List<String> getHttpRequestHeader(Interceptor.Chain chain, String name) {
        return chain.request().headers(name);
    }

    public Integer getHttpResponseStatusCode(Interceptor.Chain chain, Response response, @Nullable Throwable error) {
        return response.code();
    }

    public List<String> getHttpResponseHeader(Interceptor.Chain chain, Response response, String name) {
        return response.headers(name);
    }

    @Nullable
    public String getNetworkProtocolName(Interceptor.Chain chain, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        switch (response.protocol()) {
            case HTTP_1_0: 
            case HTTP_1_1: 
            case HTTP_2: {
                return "http";
            }
            case SPDY_3: {
                return "spdy";
            }
        }
        if ("H2_PRIOR_KNOWLEDGE".equals(response.protocol().name())) {
            return "http";
        }
        return null;
    }

    @Nullable
    public String getNetworkProtocolVersion(Interceptor.Chain chain, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        switch (response.protocol()) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2: {
                return "2";
            }
            case SPDY_3: {
                return "3.1";
            }
        }
        if ("H2_PRIOR_KNOWLEDGE".equals(response.protocol().name())) {
            return "2";
        }
        return null;
    }

    @Nullable
    public String getServerAddress(Interceptor.Chain chain) {
        return chain.request().url().host();
    }

    public Integer getServerPort(Interceptor.Chain chain) {
        return chain.request().url().port();
    }

    @Nullable
    public InetSocketAddress getNetworkPeerInetSocketAddress(Interceptor.Chain chain, @Nullable Response response) {
        Connection connection = chain.connection();
        if (connection == null) {
            return null;
        }
        SocketAddress socketAddress = connection.socket().getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }
}

