/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherClientDataRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherContainerRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherOptRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherPropertyTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecordTypes;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.EscherAggregate;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.ObjRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.Record;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.SubRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.record.TextObjectRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFCombobox;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFComment;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFObjectData;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFPicture;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFPolygon;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFTextbox;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.RecordFormatException;
import java.util.List;
import java.util.Map;

public class HSSFShapeFactory {
    public static void createShapeTree(EscherContainerRecord container, EscherAggregate agg, HSSFShapeContainer out, DirectoryNode root) {
        if (container.getRecordId() == EscherContainerRecord.SPGR_CONTAINER) {
            ObjRecord obj = null;
            EscherRecord child = container.getChild(0);
            if (!(child instanceof EscherContainerRecord)) {
                throw new IllegalArgumentException("Had unexpected type of child: " + child.getClass());
            }
            EscherClientDataRecord clientData = (EscherClientDataRecord)((EscherContainerRecord)child).getChildById(EscherClientDataRecord.RECORD_ID);
            if (null != clientData) {
                Record record = agg.getShapeToObjMapping().get(clientData);
                if (!(record instanceof ObjRecord)) {
                    throw new IllegalArgumentException("Had unexpected type of clientData: " + (record == null ? "<null>" : record.getClass()));
                }
                obj = (ObjRecord)record;
            }
            HSSFShapeGroup group = new HSSFShapeGroup(container, obj);
            List<EscherContainerRecord> children = container.getChildContainers();
            if (children.size() > 1) {
                children.subList(1, children.size()).forEach(c -> HSSFShapeFactory.createShapeTree(c, agg, group, root));
            }
            out.addShape(group);
        } else if (container.getRecordId() == EscherContainerRecord.SP_CONTAINER) {
            HSSFSimpleShape shape;
            Map<EscherRecord, Record> shapeToObj = agg.getShapeToObjMapping();
            ObjRecord objRecord = null;
            TextObjectRecord txtRecord = null;
            for (EscherRecord record : container) {
                switch (EscherRecordTypes.forTypeID(record.getRecordId())) {
                    case CLIENT_DATA: {
                        Record subRecord = shapeToObj.get(record);
                        if (!(subRecord instanceof ObjRecord)) {
                            throw new RecordFormatException("Did not have a ObjRecord: " + subRecord);
                        }
                        objRecord = (ObjRecord)subRecord;
                        break;
                    }
                    case CLIENT_TEXTBOX: {
                        Record subRecord = shapeToObj.get(record);
                        if (!(subRecord instanceof TextObjectRecord)) {
                            throw new RecordFormatException("Did not have a TextObjRecord: " + subRecord);
                        }
                        txtRecord = (TextObjectRecord)subRecord;
                        break;
                    }
                }
            }
            if (objRecord == null) {
                throw new RecordFormatException("EscherClientDataRecord can't be found.");
            }
            if (HSSFShapeFactory.isEmbeddedObject(objRecord)) {
                HSSFObjectData objectData = new HSSFObjectData(container, objRecord, root);
                out.addShape(objectData);
                return;
            }
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)objRecord.getSubRecords().get(0);
            switch (cmo.getObjectType()) {
                case 8: {
                    shape = new HSSFPicture(container, objRecord);
                    break;
                }
                case 2: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 1: {
                    shape = new HSSFSimpleShape(container, objRecord);
                    break;
                }
                case 20: {
                    shape = new HSSFCombobox(container, objRecord);
                    break;
                }
                case 30: {
                    EscherOptRecord optRecord = (EscherOptRecord)container.getChildById(EscherOptRecord.RECORD_ID);
                    if (optRecord == null) {
                        shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                        break;
                    }
                    Object property = optRecord.lookup(EscherPropertyTypes.GEOMETRY__VERTICES);
                    if (null != property) {
                        shape = new HSSFPolygon(container, objRecord, txtRecord);
                        break;
                    }
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 6: {
                    shape = new HSSFTextbox(container, objRecord, txtRecord);
                    break;
                }
                case 25: {
                    shape = new HSSFComment(container, objRecord, txtRecord, agg.getNoteRecordByObj(objRecord));
                    break;
                }
                default: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                }
            }
            out.addShape(shape);
        }
    }

    private static boolean isEmbeddedObject(ObjRecord obj) {
        for (SubRecord sub : obj.getSubRecords()) {
            if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
            return true;
        }
        return false;
    }
}

